//=============================================================================
// VisuStella MZ - Battle System CTB - Charge Turn Battle
// VisuMZ_2_BattleSystemCTB.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_BattleSystemCTB = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleSystemCTB = VisuMZ.BattleSystemCTB || {};
VisuMZ.BattleSystemCTB.version = 1.10;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 2] [Version 1.10] [BattleSystemCTB]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_System_-_CTB_VisuStella_MZ
 * @base VisuMZ_0_CoreEngine
 * @base VisuMZ_1_BattleCore
 * @orderAfter VisuMZ_1_BattleCore
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * This plugin creates a Charge Turn Battle (CTB) system using RPG Maker MZ's
 * TPB as a base. CTB functions by calculating the speed of every battler and
 * balancing them relative to one another. When it's a battler's turn, the
 * battler will either choose an action to perform immediately or charge it
 * for later depending if the skill requires charging.
 * 
 * This is a battle system where agility plays an important factor in the
 * progress of battle where higher agility values give battlers more advantage
 * and additional turns over lower agility values, which give battlers less
 * advantage and less turns.
 * 
 * A turn order display will appear to compensate for the removal of gauges.
 * The turn order display will show a preview of what the turn order could
 * possibly be like. This turn order display is variable and can be changed
 * due to player and enemy influence by using different action speeds, effects
 * provided by this plugin that alter the turn order, and more!
 * 
 * *NOTE* To use this battle system, you will need the updated version of
 * VisuStella's Core Engine. Go into its Plugin Parameters and change the
 * "Battle System" plugin parameter to "ctb".
 *
 * Features include all (but not limited to) the following:
 * 
 * * Full control over the TPB integrated mechanics converted for CTB such as
 *   speed, calculations, etc.
 * * No more waiting for gauges to show up! In fact, you won't even see the
 *   TPB gauge in-game.
 * * A turn order display that previews a potential lineup for how the
 *   participating battlers in battle will play out.
 * * Notetags that give skills and items access to manipulating a battler's
 *   CTB speed.
 * * Notetags that give skills and items access to directly manipulate a target
 *   batter's position on the Turn Order display.
 * * These mechanics are separate from ATB and TPB itself, so you can still use
 *   either battle system without affecting both of them.
 * * Through the Core Engine, you can switch in and out of CTB for a different
 *   battle system.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * VisuMZ_0_CoreEngine
 * * VisuMZ_1_BattleCore
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 *
 * ------ Tier 2 ------
 *
 * This plugin is a Tier 2 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 * 
 * *NOTE* To use this battle system, you will need the updated version of
 * VisuStella's Core Engine. Go into its Plugin Parameters and change the
 * "Battle System" plugin parameter to "ctb".
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 * 
 * Turn Order Display
 * 
 * Despite the fact that the Battle System CTB plugin uses RPG Maker MZ's TPB
 * as a base, it does not have any gauges to depict the time it takes for a
 * battler's turn to appear. Instead, a turn order display appears on the
 * screen (you pick where it can appear: top, bottom, left, or right) and shows
 * a possible preview of the battler turn order.
 * 
 * This is only a preview of what can happen because lots of different things
 * can influence the position and ordering of the turn order display, ranging
 * from skill/item speeds, notetag effects, changes in AGI, etc. What is seen
 * on the turn order display is the most likely possibility instead of the
 * exact order to occur due to the external influences.
 * 
 * ---
 * 
 * Skill & Item Speeds
 * 
 * With TPB, skills and items with negative speed values will cause the battler
 * to enter a "casting" state, meaning they have to wait extra time before the
 * action takes off. With this delayed action execution, one might assume that
 * if there is a positive speed value, the battler would require less time for
 * their next turn.
 * 
 * However, this isn't the case with RPG Maker MZ's TPB. By changing it to CTB,
 * skills and items with positive speed values will have an impact on how full
 * their CTB Speed will be in the following turn. A value of 2000 will put the
 * turn at 50% ready, 1000 will put the gauge at 25% ready, 500 will put it at
 * 12.5% ready, and so on. Notetags can also be used to influence this.
 * 
 * ---
 * 
 * JS Calculation Mechanics
 * 
 * While the calculation mechanics aren't changed from their original RPG Maker
 * MZ formulas, the functions for them have been overwritten to allow you, the
 * game developer, to alter them as you see fit.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * ---
 * 
 * === General CTB-Related Notetags ===
 * 
 * These notetags are general purpose notetags that have became available
 * through this plugin.
 * 
 * ---
 * 
 * <CTB Help>
 *  description
 *  description
 * </CTB Help>
 *
 * - Used for: Skill, Item Notetags
 * - If your game happens to support the ability to change battle systems, this
 *   notetag lets you change how the skill/item's help description text will
 *   look under CTB.
 * - This is primarily used if the skill behaves differently in CTB versus any
 *   other battle system.
 * - Replace 'description' with help text that's only displayed if the game's
 *   battle system is set to CTB.
 *
 * ---
 * 
 * === CTB Turn Order Display-Related Notetags ===
 * 
 * These notetags affect the CTB Turn Order Display
 * 
 * ---
 *
 * <CTB Turn Order Icon: x>
 *
 * - Used for: Actor, Enemy Notetags
 * - Changes the slot graphic used for the battler to a specific icon.
 * - Replace 'x' with the icon index to be used.
 * 
 * ---
 *
 * <CTB Turn Order Face: filename, index>
 *
 * - Used for: Actor, Enemy Notetags
 * - Changes the slot graphic used for the enemy to a specific face.
 * - Replace 'filename' with the filename of the image.
 *   - Do not include the file extension.
 * - Replace 'index' with the index of the face. Index values start at 0.
 * - Example: <CTB Turn Order Face: Monster, 1>
 * 
 * ---
 * 
 * === CTB Speed Manipulation-Related Notetags ===
 * 
 * These notetags are used for CTB Speed manipulation purposes.
 * 
 * ---
 *
 * <CTB Set Order: x>
 *
 * - Used for: Skill, Item Notetags
 * - Sets the target's CTB Turn Order position to exactly x.
 * - Replace 'x' with a number value depicting the exact position of the turn
 *   order position. 0 is the currently active battler and cannot be used.
 *   1 is closest to taking a turn. Higher numbers are further away.
 * - This does not affect the currently active battler.
 *
 * ---
 *
 * <CTB Change Order: +x>
 * <CTB Change Order: -x>
 *
 * - Used for: Skill, Item Notetags
 * - Sets the target's CTB Turn Order position by x slots.
 * - Replace 'x' with a number value indicating the increase or decrease.
 *   Negative values decrease the turns needed to wait while positive values
 *   increase the turns needed.
 * - This does not affect the currently active battler.
 *
 * ---
 *
 * <CTB After Speed: x%>
 *
 * - Used for: Skill, Item Notetags
 * - After using the skill/item, the user's CTB Speed will be set to x%.
 * - Replace 'x' with a percentile value representing the amount you want the
 *   CTB Speed to reset to after the skill/item's usage.
 * 
 * ---
 * 
 * <CTB Charge Speed: x%>
 * <CTB Charge Speed: +x%>
 * <CTB Charge Speed: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - If the target is in a charging state, change the target's speed amount to
 *   x% or by x% (if using the +/- variants).
 * - Replace 'x' with a percentile value representing the amount of the CTB
 *   Speed you wish to alter it to/by.
 * - This only affects targets who are in a charging state.
 * 
 * ---
 * 
 * <CTB Cast Speed: x%>
 * <CTB Cast Speed: +x%>
 * <CTB Cast Speed: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - If the target is in a casting state, change the target's speed amount to
 *   x% or by x% (if using the +/- variants).
 * - Replace 'x' with a percentile value representing the amount of the CTB
 *   Speed you wish to alter it to/by.
 * - This only affects targets who are in a casting state.
 * 
 * ---
 * 
 * === JavaScript Notetags: CTB Speed Manipulation ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * give more control over conditional CTB Speed Manipulation.
 * 
 * ---
 * 
 * <JS CTB Order>
 *  code
 *  code
 *  order = code;
 * </JS CTB Order>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'code' with JavaScript code to determine where to set the target's
 *   order on the CTB Turn Order Display to.
 * - The 'order' variable represents the final position on the Turn Order
 *   Display to place the target.
 * - The 'position' variable represents the target's current position on the
 *   Turn Order Display.
 * - This does not affect the currently active battler.
 * 
 * ---
 * 
 * <JS CTB Charge Speed>
 *  code
 *  code
 *  rate = code;
 * </JS CTB Charge Speed>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   CTB Speed to if the target is in a charging state.
 * - The 'rate' variable represents rate value the CTB Speed will change to
 *   between the values of 0 and 1.
 * - The 'rate' variable will default to the target's current CTB Speed rate
 *   if the target is in a charging state.
 * 
 * ---
 * 
 * <JS CTB Cast Speed>
 *  code
 *  code
 *  rate = code;
 * </JS CTB Cast Speed>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   CTB Speed to if the target is in a casting state.
 * - The 'rate' variable represents rate value the CTB Speed will change to
 *   between the values of 0 and 1.
 * - The 'rate' variable will default to the target's current CTB Speed rate
 *   if the target is in a casting state.
 * 
 * ---
 * 
 * <JS CTB After Speed>
 *  code
 *  code
 *  rate = code;
 * </JS CTB After Speed>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'code' with JavaScript code to determine how much to change the
 *   CTB Speed to after performing this skill/item action.
 * - The 'rate' variable represents rate value the CTB Speed will change to
 *   between the values of 0 and 1.
 * - The 'rate' variable will default to 0.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Actor Plugin Commands ===
 * 
 * ---
 *
 * Actor: Change CTB Turn Order Icon
 * - Changes the icons used for the specific actor(s) on the CTB Turn Order.
 *
 *   Actor ID(s):
 *   - Select which Actor ID(s) to affect.
 *
 *   Icon:
 *   - Changes the graphic to this icon.
 *
 * ---
 * 
 * Actor: Change CTB Turn Order Face
 * - Changes the faces used for the specific actor(s) on the CTB Turn Order.
 * 
 *   Actor ID(s):
 *   - Select which Actor ID(s) to affect.
 * 
 *   Face Name:
 *   - This is the filename for the target face graphic.
 * 
 *   Face Index:
 *   - This is the index for the target face graphic.
 * 
 * ---
 *
 * Actor: Clear CTB Turn Order Graphic
 * - Clears the CTB Turn Order graphics for the actor(s).
 * - The settings will revert to the Plugin Parameter settings.
 *
 *   Actor ID(s):
 *   - Select which Actor ID(s) to affect.
 *
 * ---
 * 
 * === Enemy Plugin Commands ===
 * 
 * ---
 *
 * Enemy: Change CTB Turn Order Icon
 * - Changes the icons used for the specific enemy(ies) on the CTB Turn Order.
 *
 *   Enemy Index(es):
 *   - Select which enemy index(es) to affect.
 *
 *   Icon:
 *   - Changes the graphic to this icon.
 *
 * ---
 *
 * Enemy: Change CTB Turn Order Face
 * - Changes the faces used for the specific enemy(ies) on the CTB Turn Order.
 *
 *   Enemy Index(es):
 *   - Select which enemy index(es) to affect.
 *
 *   Face Name:
 *   - This is the filename for the target face graphic.
 *
 *   Face Index:
 *   - This is the index for the target face graphic.
 *
 * ---
 *
 * Enemy: Clear CTB Turn Order Graphic
 * - Clears the CTB Turn Order graphics for the enemy(ies).
 * - The settings will revert to the Plugin Parameter settings.
 *
 *   Enemy Index(es):
 *   - Select which enemy index(es) to affect.
 *
 * ---
 * 
 * === System Plugin Commands ===
 * 
 * ---
 * 
 * System: CTB Turn Order Visibility
 * - Determine the visibility of the CTB Turn Order Display.
 * 
 *   Visibility:
 *   - Changes the visibility of the CTB Turn Order Display.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Mechanics settings used for Battle System CTB. The majority of these are
 * JavaScript-based and will require knowledge of JavaScript to fully utilize
 * the plugin parameters.
 *
 * ---
 *
 * General
 * 
 *   Device Friendly:
 *   - Make the calculations more device friendly?
 *   - Or make it for desktop at full strength?
 * 
 *   Escape Fail Penalty:
 *   - Gauge penalty if an escape attempt fails.
 *
 * ---
 *
 * JavaScript
 * 
 *   JS: Initial Speed:
 *   - JavaScript code to determine how much speed to give each battler at the
 *     start of battle.
 * 
 *   JS: Speed:
 *   - JavaScript code to determine how much speed a battler has.
 * 
 *   JS: Base Speed:
 *   - JavaScript code to determine how much base speed a battler has.
 * 
 *   JS: Relative Speed:
 *   - JavaScript code to determine what is the relative speed of a battler.
 * 
 *   JS: Acceleration:
 *   - JavaScript code to determine how much gauges accelerate by relative to
 *     reference time.
 * 
 *   JS: Cast Time:
 *   - JavaScript code to determine how much cast time is used for skills/items
 *     with negative speed modifiers.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Order Change Effects Settings
 * ============================================================================
 * 
 * Whenever the turn order a battler is changed by a CTB Order notetag, play
 * these effects on the target battler. These effects do not play if the order
 * was changed due to speed changes and only through the specific notetags.
 *
 * ---
 *
 * Delay Turn Order > Animation
 * 
 *   Animation ID:
 *   - Play this animation when the effect activates.
 *   - Occurs when the turn order is delayed.
 * 
 *   Mirror Animation:
 *   - Mirror the effect animation?
 *   - Occurs when the turn order is delayed.
 * 
 *   Mute Animation:
 *   - Mute the effect animation?
 *   - Occurs when the turn order is delayed.
 *
 * ---
 *
 * Delay Turn Order > Popups
 * 
 *   Text:
 *   - Text displayed upon the effect activating.
 *   - Occurs when the turn order is delayed.
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 *
 * ---
 *
 * Rush Turn Order > Animation
 * 
 *   Animation ID:
 *   - Play this animation when the effect activates.
 *   - Occurs when the turn order is rushed.
 * 
 *   Mirror Animation:
 *   - Mirror the effect animation?
 *   - Occurs when the turn order is rushed.
 * 
 *   Mute Animation:
 *   - Mute the effect animation?
 *   - Occurs when the turn order is rushed.
 *
 * ---
 *
 * Rush Turn Order > Popups
 * 
 *   Text:
 *   - Text displayed upon the effect activating.
 *   - Occurs when the turn order is rushed.
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Turn Order Display Settings
 * ============================================================================
 *
 * Turn Order Display settings used for Battle System CTB. These adjust how the
 * visible turn order appears in-game.
 *
 * ---
 *
 * General
 * 
 *   Display Position:
 *   - Select where the Turn Order will appear on the screen.
 * 
 *     Offset X:
 *     - How much to offset the X coordinate by.
 *     - Negative: left. Positive: right.
 * 
 *     Offset Y:
 *     - How much to offset the Y coordinate by.
 *     - Negative: up. Positive: down.
 * 
 *   Reposition for Help?:
 *   - If the display position is at the top, reposition the display when the
 *     help window is open?
 * 
 *   Reposition Log?:
 *   - If the display position is at the top, reposition the Battle Log Window
 *     to be lower?
 * 
 *   Forward Direction:
 *   - Decide on the direction of the Turn Order.
 *   - Settings may vary depending on position.
 *   - Left to Right / Down to Up
 *   - Right to Left / Up to Down
 * 
 *   Subject Distance:
 *   - How far do you want the currently active battler to distance itself from
 *     the rest of the Turn Order?
 * 
 *   Screen Buffer:
 *   - What distance do you want the display to be away from the edge of the
 *     screen by?
 *
 * ---
 *
 * Reposition For Help
 * 
 *   Repostion X By:
 *   Repostion Y By:
 *   - Reposition the display's coordinates by this much when the Help Window
 *     is visible.
 *
 * ---
 *
 * Slots
 * 
 *   Total Horizontal:
 *   - How many slots do you want to display for top and bottom Turn Order
 *     Display positions?
 * 
 *   Total Vertical:
 *   - How many slots do you want to display for left and right Turn Order
 *     Display positions?
 * 
 *   Length:
 *   - How many pixels long should the slots be on the Turn Order display?
 * 
 *   Thin:
 *   - How many pixels thin should the slots be on the Turn Order display?
 * 
 *   Update Frames:
 *   - How many frames should it take for the slots to update their
 *     positions by?
 *
 * ---
 *
 * Slot Border
 * 
 *   Show Border?:
 *   - Show borders for the slot sprites?
 * 
 *   Border Thickness:
 *   - How many pixels thick should the colored portion of the border be?
 * 
 *   Actors
 *   Enemies
 * 
 *     Border Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors
 *       from the Window Skin.
 * 
 *     Border Skin:
 *     - Optional. Place a skin on the actor/enemy borders instead of
 *       rendering them?
 *
 * ---
 *
 * Slot Sprites
 * 
 *   Actors
 * 
 *     Sprite Type:
 *     - Select the type of sprite used for the actor graphic.
 *     - Face Graphic - Show the actor's face.
 *     - Icon - Show a specified icon.
 *     - Sideview Actor - Show the actor's sideview battler.
 * 
 *     Default Icon:
 *     - Which icon do you want to use for actors by default?
 * 
 *   Enemies
 * 
 *     Sprite Type:
 *     - Select the type of sprite used for the enemy graphic.
 *     - Face Graphic - Show a specified face graphic.
 *     - Icon - Show a specified icon.
 *     - Enemy - Show the enemy's graphic or sideview battler.
 * 
 *     Default Face Name:
 *     - Use this default face graphic if there is no specified face.
 * 
 *     Default Face Index:
 *     - Use this default face index if there is no specified index.
 * 
 *     Default Icon:
 *     - Which icon do you want to use for enemies by default?
 * 
 *     Match Hue?:
 *     - Match the hue for enemy battlers?
 *     - Does not apply if there's a sideview battler.
 *
 * ---
 *
 * Slot Letter
 * 
 *   Show Enemy Letter?:
 *   - Show the enemy's letter on the slot sprite?
 * 
 *   Font Name:
 *   - The font name used for the text of the Letter.
 *   - Leave empty to use the default game's font.
 * 
 *   Font Size:
 *   - The font size used for the text of the Letter.
 *
 * ---
 *
 * Slot Background
 * 
 *   Show Background?:
 *   - Show the background on the slot sprite?
 * 
 *   Actors
 *   Enemies
 * 
 *     Background Color 1:
 *     Background Color 2:
 *     - Use #rrggbb for custom colors or regular numbers for text colors
 *       from the Window Skin.
 * 
 *     Background Skin:
 *     - Optional. Use a skin for the actor background instead of
 *       rendering them?
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.10: June 18, 2021
 * * Bug Fixes!
 * ** Fixed turn order icon reappearing for a dying battler. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated with new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu!
 * *** Plugin Parameters > Mechanics > General > Device Friendly
 * **** Make the calculations more device friendly? Or make it for desktop at
 *      full strength?
 * 
 * Version 1.09: June 11, 2021
 * * Bug Fixes!
 * ** Plugin Command: "Enemy: Change CTB Turn Order Face" should now properly
 *    change to the correct face index. Fix made by Arisu.
 * 
 * Version 1.08: April 23, 2021
 * * Feature Update!
 * ** When using 100% for After Speed notetag, no other battler is able to
 *    interrupt the action. Update made by Olivia.
 * 
 * Version 1.07: March 19, 2021
 * * Feature Update!
 * ** Turn Order Window calculations slightly tweaked for times when the window
 *    layer is bigger than it should be. Update made by Olivia.
 * 
 * Version 1.06: January 22, 2021
 * * Feature Update!
 * ** A different kind of end battle check is now made to determine hiding the
 *    turn order display. Update made by Olivia.
 * ** Added in a built-in anti-softlock check.
 * 
 * Version 1.05: January 1, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.04: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.03: November 1, 2020
 * * Documentation Update!
 * ** Help file updated with new features.
 * * Optimization Update!
 * ** Uses less resources for turn order display.
 * * New Features!
 * ** New Plugin Command by Irina!
 * *** Actor: Change CTB Turn Order Face
 * **** Changes the faces used for the specific actor(s) on the CTB Turn Order.
 * 
 * Version 1.02: October 25, 2020
 * * Bug Fixes!
 * ** Turn Order icons no longer stay invisible after rotating out completely.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated with new features.
 * * Feature Update!
 * ** <CTB Turn Order Face: filename, index> notetag now works with actors.
 *    Update made by Irina.
 * 
 * Version 1.01: October 18, 2020
 * * Bug Fixes!
 * ** Action times + should no longer freeze the game. Fix made by Yanfly.
 * ** Actors and enemies without actions will no longer softlock the game.
 *    Fix made by Yanfly.
 * ** Auto-battle during CTB should no longer lock the game! Fix by Yanfly.
 * ** Enemies without any actions should no longer cause endless loops.
 *    Fix made by Yanfly.
 * ** SV_Actor graphics on the Turn Order display are now centered.
 *    Fix made by Yanfly.
 *
 * Version 1.00 Official Release: October 19, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CtbTurnOrderActorIcon
 * @text Actor: Change CTB Turn Order Icon
 * @desc Changes the icons used for the specific actor(s) on the CTB Turn Order.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) to affect.
 * @default ["1"]
 *
 * @arg IconIndex:num
 * @text Icon
 * @desc Changes the graphic to this icon.
 * @default 84
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CtbTurnOrderActorFace
 * @text Actor: Change CTB Turn Order Face
 * @desc Changes the faces used for the specific actor(s) on the CTB Turn Order.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) to affect.
 * @default ["1"]
 *
 * @arg FaceName:str
 * @text Face Name
 * @type file
 * @dir img/faces/
 * @desc This is the filename for the target face graphic.
 * @default Actor1
 *
 * @arg FaceIndex:num
 * @text Face Index
 * @type number
 * @desc This is the index for the target face graphic.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CtbTurnOrderClearActorGraphic
 * @text Actor: Clear CTB Turn Order Graphic
 * @desc Clears the CTB Turn Order graphics for the actor(s).
 * The settings will revert to the Plugin Parameter settings.
 *
 * @arg Actors:arraynum
 * @text Actor ID(s)
 * @type actor[]
 * @desc Select which Actor ID(s) to affect.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CtbTurnOrderEnemyIcon
 * @text Enemy: Change CTB Turn Order Icon
 * @desc Changes the icons used for the specific enemy(ies) on the CTB Turn Order.
 *
 * @arg Enemies:arraynum
 * @text Enemy Index(es)
 * @type number[]
 * @desc Select which enemy index(es) to affect.
 * @default ["1"]
 *
 * @arg IconIndex:num
 * @text Icon
 * @desc Changes the graphic to this icon.
 * @default 298
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CtbTurnOrderEnemyFace
 * @text Enemy: Change CTB Turn Order Face
 * @desc Changes the faces used for the specific enemy(ies) on the CTB Turn Order.
 *
 * @arg Enemies:arraynum
 * @text Enemy Index(es)
 * @type number[]
 * @desc Select which enemy index(es) to affect.
 * @default ["1"]
 *
 * @arg FaceName:str
 * @text Face Name
 * @parent EnemySprite
 * @type file
 * @dir img/faces/
 * @desc This is the filename for the target face graphic.
 * @default Monster
 *
 * @arg FaceIndex:num
 * @text Face Index
 * @parent EnemySprite
 * @type number
 * @desc This is the index for the target face graphic.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CtbTurnOrderClearEnemyGraphic
 * @text Enemy: Clear CTB Turn Order Graphic
 * @desc Clears the CTB Turn Order graphics for the enemy(ies).
 * The settings will revert to the Plugin Parameter settings.
 *
 * @arg Enemies:arraynum
 * @text Enemy Index(es)
 * @type number[]
 * @desc Select which enemy index(es) to affect.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemTurnOrderVisibility
 * @text System: CTB Turn Order Visibility
 * @desc Determine the visibility of the CTB Turn Order Display.
 *
 * @arg Visible:eval
 * @text Visibility
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Changes the visibility of the CTB Turn Order Display.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleSystemCTB
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Mechanics settings used for Battle System CTB.
 * @default {"General":"","EscapeFailPenalty:num":"-1.00","JavaScript":"","InitialGaugeJS:str":"Math.random() * 0.50","TpbSpeedCalcJS:func":"\"// Declare Constants\\nconst user = this;\\n\\n// Process Calculation\\nlet speed = Math.sqrt(user.agi) + 1;\\n\\n// Return Value\\nreturn speed;\"","TpbBaseSpeedCalcJS:func":"\"// Declare Constants\\nconst user = this;\\nconst baseAgility = user.paramBasePlus(6);\\n\\n// Process Calculation\\nlet speed = Math.sqrt(baseAgility) + 1;\\n\\n// Return Value\\nreturn speed;\"","BattlerRelativeSpeedJS:func":"\"// Declare Constants\\nconst user = this;\\nconst speed = user.tpbSpeed()\\nconst partyBaseSpeed = $gameParty.tpbBaseSpeed();\\n\\n// Process Calculation\\nlet relativeSpeed = speed / partyBaseSpeed;\\n\\n// Return Value\\nreturn relativeSpeed;\"","TpbAccelerationJS:func":"\"// Declare Constants\\nconst user = this;\\nconst speed = user.tpbRelativeSpeed();\\nconst referenceTime = $gameParty.tpbReferenceTime();\\n\\n// Process Calculation\\nlet acceleration = speed / referenceTime;\\n\\n// Return Value\\nreturn acceleration;\"","TpbCastTimeJS:func":"\"// Declare Constants\\nconst user = this;\\nconst actions = user._actions.filter(action => action.isValid());\\nconst items = actions.map(action => action.item());\\nconst delay = items.reduce((r, item) => r + Math.max(0, -item.speed), 0);\\n\\n// Process Calculation\\nlet time = Math.sqrt(delay) / user.tpbSpeed();\\n\\n// Return Value\\nreturn time;\""}
 *
 * @param Effect:struct
 * @text Order Change Effects
 * @type struct<Effect>
 * @desc Effects to play when the Turn Order is changed in CTB.
 * @default {"Delay":"","DelayAnimation":"","DelayAnimationID:num":"54","DelayMirror:eval":"false","DelayMute:eval":"false","DelayPopups":"","DelayPopupText:str":"DELAY","DelayTextColor:str":"25","DelayFlashColor:eval":"[255, 0, 0, 160]","DelayFlashDuration:num":"60","Rush":"","RushAnimation":"","RushAnimationID:num":"51","RushMirror:eval":"false","RushMute:eval":"false","RushPopups":"","RushPopupText:str":"RUSH","RushTextColor:str":"24","RushFlashColor:eval":"[0, 255, 0, 160]","RushFlashDuration:num":"60"}
 *
 * @param TurnOrder:struct
 * @text Turn Order Display
 * @type struct<TurnOrder>
 * @desc Turn Order Display settings used for Battle System CTB.
 * @default {"General":"","DisplayPosition:str":"top","DisplayOffsetX:num":"0","DisplayOffsetY:num":"0","RepositionTopForHelp:eval":"true","RepositionLogWindow:eval":"true","OrderDirection:eval":"true","SubjectDistance:num":"8","ScreenBuffer:num":"20","Reposition":"","RepositionTopHelpX:num":"0","RepositionTopHelpY:num":"96","Slots":"","TotalHorzSprites:num":"16","TotalVertSprites:num":"10","SpriteLength:num":"72","SpriteThin:num":"36","UpdateFrames:num":"24","Border":"","ShowMarkerBorder:eval":"true","BorderActor":"","ActorBorderColor:str":"4","ActorSystemBorder:str":"","BorderEnemy":"","EnemyBorderColor:str":"2","EnemySystemBorder:str":"","BorderThickness:num":"2","Sprite":"","ActorSprite":"","ActorBattlerType:str":"face","ActorBattlerIcon:num":"84","EnemySprite":"","EnemyBattlerType:str":"enemy","EnemyBattlerFaceName:str":"Monster","EnemyBattlerFaceIndex:num":"1","EnemyBattlerIcon:num":"298","EnemyBattlerMatchHue:eval":"true","Letter":"","EnemyBattlerDrawLetter:eval":"true","EnemyBattlerFontFace:str":"","EnemyBattlerFontSize:num":"16","Background":"","ShowMarkerBg:eval":"true","BackgroundActor":"","ActorBgColor1:str":"19","ActorBgColor2:str":"9","ActorSystemBg:str":"","BackgroundEnemy":"","EnemyBgColor1:str":"19","EnemyBgColor2:str":"18","EnemySystemBg:str":""}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param General
 *
 * @param DeviceFriendly:eval
 * @text Device Friendly
 * @parent General
 * @type boolean
 * @on Device Friendly
 * @off For Desktops
 * @desc Make the calculations more device friendly?
 * Or make it for desktop at full strength?
 * @default false
 * 
 * @param EscapeFailPenalty:num
 * @text Escape Fail Penalty
 * @parent General
 * @desc Gauge penalty if an escape attempt fails.
 * @default -1.00
 *
 * @param JavaScript
 *
 * @param InitialGaugeJS:str
 * @text JS: Initial Speed
 * @parent JavaScript
 * @desc JavaScript code to determine how much speed to give
 * each battler at the start of battle.
 * @default Math.random() * 0.5
 *
 * @param TpbSpeedCalcJS:func
 * @text JS: Speed
 * @parent JavaScript
 * @type note
 * @desc JavaScript code to determine how much speed a battler has.
 * @default "// Declare Constants\nconst user = this;\n\n// Process Calculation\nlet speed = Math.sqrt(user.agi) + 1;\n\n// Return Value\nreturn speed;"
 * 
 * @param TpbBaseSpeedCalcJS:func
 * @text JS: Base Speed
 * @parent JavaScript
 * @type note
 * @desc JavaScript code to determine how much base speed a battler has.
 * @default "// Declare Constants\nconst user = this;\nconst baseAgility = user.paramBasePlus(6);\n\n// Process Calculation\nlet speed = Math.sqrt(baseAgility) + 1;\n\n// Return Value\nreturn speed;"
 * 
 * @param BattlerRelativeSpeedJS:func
 * @text JS: Relative Speed
 * @parent JavaScript
 * @type note
 * @desc JavaScript code to determine what is the relative speed of a battler.
 * @default "// Declare Constants\nconst user = this;\nconst speed = user.tpbSpeed()\nconst partyBaseSpeed = $gameParty.tpbBaseSpeed();\n\n// Process Calculation\nlet relativeSpeed = speed / partyBaseSpeed;\n\n// Return Value\nreturn relativeSpeed;"
 * 
 * @param TpbAccelerationJS:func
 * @text JS: Acceleration
 * @parent JavaScript
 * @type note
 * @desc JavaScript code to determine how much gauges accelerate by relative to reference time.
 * @default "// Declare Constants\nconst user = this;\nconst speed = user.tpbRelativeSpeed();\nconst referenceTime = $gameParty.tpbReferenceTime();\n\n// Process Calculation\nlet acceleration = speed / referenceTime;\n\n// Return Value\nreturn acceleration;"
 * 
 * @param TpbCastTimeJS:func
 * @text JS: Cast Time
 * @parent JavaScript
 * @type note
 * @desc JavaScript code to determine how much cast time is used for skills/items with negative speed modifiers.
 * @default "// Declare Constants\nconst user = this;\nconst actions = user._actions.filter(action => action.isValid());\nconst items = actions.map(action => action.item());\nconst delay = items.reduce((r, item) => r + Math.max(0, -item.speed), 0);\n\n// Process Calculation\nlet time = Math.sqrt(delay) / user.tpbSpeed();\n\n// Return Value\nreturn time;"
 * 
 */
/* ----------------------------------------------------------------------------
 * Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Effect:
 *
 * @param Delay
 * @text Delay Turn Order
 * 
 * @param DelayAnimation
 * @text Animation
 * @parent Delay
 *
 * @param DelayAnimationID:num
 * @text Animation ID
 * @parent DelayAnimation
 * @type animation
 * @desc Play this animation when the effect activates.
 * Occurs when the turn order is delayed.
 * @default 54
 *
 * @param DelayMirror:eval
 * @text Mirror Animation
 * @parent DelayAnimation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the effect animation?
 * Occurs when the turn order is delayed.
 * @default false
 *
 * @param DelayMute:eval
 * @text Mute Animation
 * @parent DelayAnimation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the effect animation?
 * Occurs when the turn order is delayed.
 * @default false
 *
 * @param DelayPopups
 * @text Popups
 * @parent Delay
 *
 * @param DelayPopupText:str
 * @text Text
 * @parent DelayPopups
 * @desc Text displayed upon the effect activating.
 * Occurs when the turn order is delayed.
 * @default DELAY
 *
 * @param DelayTextColor:str
 * @text Text Color
 * @parent DelayPopups
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 25
 *
 * @param DelayFlashColor:eval
 * @text Flash Color
 * @parent DelayPopups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @param DelayFlashDuration:num
 * @text Flash Duration
 * @parent DelayPopups
 * @type Number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @param Rush
 * @text Rush Turn Order
 * 
 * @param RushAnimation
 * @text Animation
 * @parent Rush
 *
 * @param RushAnimationID:num
 * @text Animation ID
 * @parent RushAnimation
 * @type animation
 * @desc Play this animation when the effect activates.
 * Occurs when the turn order is rushed.
 * @default 51
 *
 * @param RushMirror:eval
 * @text Mirror Animation
 * @parent RushAnimation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the effect animation?
 * Occurs when the turn order is rushed.
 * @default false
 *
 * @param RushMute:eval
 * @text Mute Animation
 * @parent RushAnimation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the effect animation?
 * Occurs when the turn order is rushed.
 * @default false
 *
 * @param RushPopups
 * @text Popups
 * @parent Rush
 *
 * @param RushPopupText:str
 * @text Text
 * @parent RushPopups
 * @desc Text displayed upon the effect activating.
 * Occurs when the turn order is rushed.
 * @default RUSH
 *
 * @param RushTextColor:str
 * @text Text Color
 * @parent RushPopups
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 24
 *
 * @param RushFlashColor:eval
 * @text Flash Color
 * @parent RushPopups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 255, 0, 160]
 * 
 * @param RushFlashDuration:num
 * @text Flash Duration
 * @parent RushPopups
 * @type Number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 */
/* ----------------------------------------------------------------------------
 * Turn Order Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~TurnOrder:
 *
 * @param General
 *
 * @param DisplayPosition:str
 * @text Display Position
 * @parent General
 * @type select
 * @option top
 * @option bottom
 * @option left
 * @option right
 * @desc Select where the Turn Order will appear on the screen.
 * @default top
 * 
 * @param DisplayOffsetX:num
 * @text Offset X
 * @parent DisplayPosition:str
 * @desc How much to offset the X coordinate by.
 * Negative: left. Positive: right.
 * @default 0
 * 
 * @param DisplayOffsetY:num
 * @text Offset Y
 * @parent DisplayPosition:str
 * @desc How much to offset the Y coordinate by.
 * Negative: up. Positive: down.
 * @default 0
 *
 * @param RepositionTopForHelp:eval
 * @text Reposition for Help?
 * @parent DisplayPosition:str
 * @type boolean
 * @on Reposition
 * @off Stay
 * @desc If the display position is at the top, reposition the
 * display when the help window is open?
 * @default true
 *
 * @param RepositionLogWindow:eval
 * @text Reposition Log?
 * @parent DisplayPosition:str
 * @type boolean
 * @on Reposition
 * @off Stay
 * @desc If the display position is at the top, reposition the
 * Battle Log Window to be lower?
 * @default true
 *
 * @param OrderDirection:eval
 * @text Forward Direction
 * @parent General
 * @type boolean
 * @on Left to Right / Down to Up
 * @off Right to Left / Up to Down
 * @desc Decide on the direction of the Turn Order.
 * Settings may vary depending on position.
 * @default true
 *
 * @param SubjectDistance:num
 * @text Subject Distance
 * @parent General
 * @type number
 * @desc How far do you want the currently active battler to
 * distance itself from the rest of the Turn Order?
 * @default 8
 *
 * @param ScreenBuffer:num
 * @text Screen Buffer
 * @parent General
 * @type number
 * @desc What distance do you want the display to be away
 * from the edge of the screen by?
 * @default 20
 * 
 * @param Reposition
 * @text Reposition For Help
 *
 * @param RepositionTopHelpX:num
 * @text Repostion X By
 * @parent Reposition
 * @desc Reposition the display's X coordinates by this much when
 * the Help Window is visible.
 * @default 0
 *
 * @param RepositionTopHelpY:num
 * @text Repostion Y By
 * @parent Reposition
 * @desc Reposition the display's Y coordinates by this much when
 * the Help Window is visible.
 * @default 96
 * 
 * @param Slots
 *
 * @param TotalHorzSprites:num
 * @text Total Horizontal
 * @parent Slots
 * @type number
 * @min 1
 * @desc How many slots do you want to display for top and
 * bottom Turn Order Display positions?
 * @default 16
 *
 * @param TotalVertSprites:num
 * @text Total Vertical
 * @parent Slots
 * @type number
 * @min 1
 * @desc How many slots do you want to display for left and
 * right Turn Order Display positions?
 * @default 10
 *
 * @param SpriteLength:num
 * @text Length
 * @parent Slots
 * @type number
 * @min 1
 * @desc How many pixels long should the slots be on the
 * Turn Order display?
 * @default 72
 *
 * @param SpriteThin:num
 * @text Thin
 * @parent Slots
 * @type number
 * @min 1
 * @desc How many pixels thin should the slots be on the
 * Turn Order display?
 * @default 36
 *
 * @param UpdateFrames:num
 * @text Update Frames
 * @parent Slots
 * @type number
 * @min 1
 * @desc How many frames should it take for the slots to
 * update their positions by?
 * @default 24
 *
 * @param Border
 * @text Slot Border
 *
 * @param ShowMarkerBorder:eval
 * @text Show Border?
 * @parent Border
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show borders for the slot sprites?
 * @default true
 *
 * @param BorderThickness:num
 * @text Border Thickness
 * @parent Markers
 * @type number
 * @min 1
 * @desc How many pixels thick should the colored portion of the border be?
 * @default 2
 *
 * @param BorderActor
 * @text Actors
 * @parent Border
 *
 * @param ActorBorderColor:str
 * @text Border Color
 * @parent BorderActor
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 4
 *
 * @param ActorSystemBorder:str
 * @text Border Skin
 * @parent BorderActor
 * @type file
 * @dir img/system/
 * @desc Optional. Place a skin on the actor borders instead of rendering them?
 * @default 
 *
 * @param BorderEnemy
 * @text Enemies
 * @parent Border
 *
 * @param EnemyBorderColor:str
 * @text Border Color
 * @parent BorderEnemy
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 2
 *
 * @param EnemySystemBorder:str
 * @text Border Skin
 * @parent BorderEnemy
 * @type file
 * @dir img/system/
 * @desc Optional. Place a skin on the enemy borders instead of rendering them?
 * @default 
 *
 * @param Sprite
 * @text Slot Sprites
 *
 * @param ActorSprite
 * @text Actors
 * @parent Sprite
 *
 * @param ActorBattlerType:str
 * @text Sprite Type
 * @parent ActorSprite
 * @type select
 * @option Face Graphic - Show the actor's face.
 * @value face
 * @option Icon - Show a specified icon.
 * @value icon
 * @option Sideview Actor - Show the actor's sideview battler.
 * @value svactor
 * @desc Select the type of sprite used for the actor graphic.
 * @default face
 *
 * @param ActorBattlerIcon:num
 * @text Default Icon
 * @parent ActorSprite
 * @desc Which icon do you want to use for actors by default?
 * @default 84
 *
 * @param EnemySprite
 * @text Enemies
 * @parent Sprite
 *
 * @param EnemyBattlerType:str
 * @text Sprite Type
 * @parent EnemySprite
 * @type select
 * @option Face Graphic - Show a specified face graphic.
 * @value face
 * @option Icon - Show a specified icon.
 * @value icon
 * @option Enemy - Show the enemy's graphic or sideview battler.
 * @value enemy
 * @desc Select the type of sprite used for the enemy graphic.
 * @default enemy
 *
 * @param EnemyBattlerFaceName:str
 * @text Default Face Name
 * @parent EnemySprite
 * @type file
 * @dir img/faces/
 * @desc Use this default face graphic if there is no specified face.
 * @default Monster
 *
 * @param EnemyBattlerFaceIndex:num
 * @text Default Face Index
 * @parent EnemySprite
 * @type number
 * @desc Use this default face index if there is no specified index.
 * @default 1
 *
 * @param EnemyBattlerIcon:num
 * @text Default Icon
 * @parent EnemySprite
 * @desc Which icon do you want to use for enemies by default?
 * @default 298
 *
 * @param EnemyBattlerMatchHue:eval
 * @text Match Hue?
 * @parent EnemySprite
 * @type boolean
 * @on Match
 * @off Don't Match
 * @desc Match the hue for enemy battlers?
 * Does not apply if there's a sideview battler.
 * @default true
 *
 * @param Letter
 * @text Slot Letter
 *
 * @param EnemyBattlerDrawLetter:eval
 * @text Show Enemy Letter?
 * @parent Letter
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the enemy's letter on the slot sprite?
 * @default true
 *
 * @param EnemyBattlerFontFace:str
 * @text Font Name
 * @parent Letter
 * @desc The font name used for the text of the Letter.
 * Leave empty to use the default game's font.
 * @default 
 *
 * @param EnemyBattlerFontSize:num
 * @text Font Size
 * @parent Letter
 * @min 1
 * @desc The font size used for the text of the Letter.
 * @default 16
 *
 * @param Background
 * @text Slot Background
 *
 * @param ShowMarkerBg:eval
 * @text Show Background?
 * @parent Background
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the background on the slot sprite?
 * @default true
 *
 * @param BackgroundActor
 * @text Actors
 * @parent Background
 *
 * @param ActorBgColor1:str
 * @text Background Color 1
 * @parent BackgroundActor
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param ActorBgColor2:str
 * @text Background Color 2
 * @parent BackgroundActor
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 9
 *
 * @param ActorSystemBg:str
 * @text Background Skin
 * @parent BackgroundActor
 * @type file
 * @dir img/system/
 * @desc Optional. Use a skin for the actor background instead of rendering them?
 * @default 
 *
 * @param BackgroundEnemy
 * @text Enemies
 * @parent Background
 *
 * @param EnemyBgColor1:str
 * @text Background Color 1
 * @parent BackgroundEnemy
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 19
 *
 * @param EnemyBgColor2:str
 * @text Background Color 2
 * @parent BackgroundEnemy
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 18
 *
 * @param EnemySystemBg:str
 * @text Background Skin
 * @parent BackgroundEnemy
 * @type file
 * @dir img/system/
 * @desc Optional. Use a skin for the enemy background instead of rendering them?
 * @default 
 *
 */
//=============================================================================

const _0x3fbc=['createOrderJS','createCTBTurnOrderWindow','updateTpbChargeTimeCTB','containerPosition','find','aGAxc','icon','EnemyBattlerFaceIndex','%1TextColor','actor','TpbAccelerationJS','moBUV','changeTurnOrderByCTB','aXSXg','updateTpb','checkCtbAntiSoftlock','clear','Scene_Battle_createAllWindows','(?:CTB)','CtbTurnOrderEnemyFace','_fadeTarget','isActiveTpb','applyItemUserEffect','PgpSO','isEnemy','64968mlKPjR','Window_StatusBase_placeGauge','updateTurnOrderCTB','1482102KnZYaU','GGivd','loadSystem','OjIoZ','initTpbChargeTime','some','loadSvEnemy','_graphicFaceIndex','RepositionTopForHelp','fillRect','clearTpbChargeTime','916700mPgnDJ','removeCurrentAction','updateTpbCastTimeCTB','569277JGmXKU','createBackgroundSprite','Game_Battler_tpbRequiredCastTime','width','OcjPZ','createTurnOrderCTBGraphicFaceName','Scene_Boot_onDatabaseLoaded','KMCLP','updateAllTpbBattlersCTB','onCtbOrderChange','ShowMarkerBg','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20keyType\x20=\x20\x27%2\x27;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20rate\x20=\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(keyType\x20===\x20\x27Charge\x27)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20rate\x20=\x20target._tpbChargeTime;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20else\x20if\x20(keyType\x20===\x20\x27Cast\x27)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20rate\x20=\x20target._tpbCastTime\x20/\x20Math.max(target.tpbRequiredCastTime(),\x201);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20originalValue\x20=\x20rate;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(rate)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20rate\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20rate\x20to\x20%2\x27.format(\x27\x27,originalValue));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20rate\x20=\x20originalValue;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20rate;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','clearRect','createInitialPositions','qlevR','ceil','UJwQK','subject','TurnOrderCTBGraphicType','_tpbChargeTime','hahrH','isTpbReady','Weapon-%1-%2','_subject','YEixz','NUM','Game_Battler_tpbAcceleration','DisplayOffsetY','createTestBitmap','center','EMJmQ','indexOf','currentAction','allBattleMembers','createAllWindows','KHjpR','hWAxZ','gHmfA','concat','createBattlerSprites','createRateJS','_unit','requestFauxAnimation','UrICW','_homeY','_turnOrderInnerSprite','ParseSkillNotetags','ConvertParams','ctbTicksToGoalAddedCastTime','rTGsk','emSIG','_turnOrderContainer','_onRestrictBypassCtbReset','BattleManager_updateAllTpbBattlers','Game_System_initialize','createChildren','%1AnimationID','Game_Battler_onRestrict','FNzZt','ARRAYFUNC','TpbCastTimeJS','ParseAllNotetags','BattleManager_isActiveTpb','initTpbChargeTimeCTB','filter','EnemyBattlerType','updateBattleContainerOrder','svBattlerName','windowRect','charging','EhMpz','BattlerRelativeSpeedJS','ctbTicksToGoal','ScreenBuffer','_inputting','bind','updateTurnOrder','tpbAcceleration','containerWindow','aXGkp','_ctbTurnOrderWindow','constructor','UICgc','aBVqK','TurnOrder','iconWidth','updateAllTpbBattlers','boxHeight','Enemies','Enemy','setBattleSystemCTBTurnOrderVisible','setText','processUpdateGraphic','ARRAYSTR','enemy','_autoBattle','BattleManager_startBattle','EnemyBattlerFontFace','isRestricted','endAction','mainFontFace','round','_letterSprite','XyATH','THzaY','Game_Battler_applyTpbPenalty','tpbBaseSpeed','Effect','updateTpbChargeTime','description','Game_Battler_tpbSpeed','_graphicFaceName','updatePosition','_tpbCastTime','processTurn','getCurrentTurnOrderPositionCTB','twvPU','setBlendColor','Jqnca','isTpb','log','checkPosition','parameters','EVAL','isAttack','OrderDirection','_windowLayer','_positionTargetX','processCtbAntiSoftlock','tSphR','startBattle','DeviceFriendly','TurnOrderCTBGraphicFaceName','ARRAYNUM','postEndActionCTB','xsMti','blt','createGraphicSprite','JYKBd','xEwTG','speed','updateTpbBattler','DGbLj','traitObjects','ULZhc','processTurnCTB','opacity','cbPJX','Game_BattlerBase_hide','changeFaceGraphicBitmap','updateLetter','battler','tpbSpeed','Order','padding','setHue','battleEnd','loadSvActor','battleSys','60WZxqMR','children','TotalVertSprites','isInputting','svactor','_dupe','EscapeFailPenalty','status','kgOir','ctbHasInstantActionAfter','_phase','changeEnemyGraphicBitmap','setupTextPopup','OoAct','isValid','TpbBaseSpeedCalcJS','visible','defaultPosition','drawText','battlerName','#000000','SpriteThin','height','startActorInput','_graphicSprite','mtalg','Cqapg','isAlive','crhzB','TPkgG','_graphicType','faceIndex','tLZMq','map','battlerHue','updateVisibility','bitmapHeight','FaceName','BattleManager_updateTurn','ticksLeft','Actor','preEndActionCTB','Cast','STR','State-%1-%2','trim','isActing','undecided','TurnOrderCTBGraphicFaceIndex','IconIndex','includes','addInnerChild','getChildIndex','ffMvi','iconHeight','face','setTurnOrderCTB','Parse_Notetags_CreateJS','_isAppeared','_index','hide','BattleManager_processTurn','dUisT','_letter','_graphicHue','ezNND','_helpWindow','BattleManager_isTpb','PPeij','changeIconGraphicBitmap','bitmapWidth','_isBattleOver','41bFhMWg','isCtbChargingState','addLoadListener','update','fontFace','_backgroundSprite','left','anchor','ParseItemNotetags','getNextSubject','attackSpeed','_ctbAfterSpeed','IcIoJ','rotateCTBSprites','isAnyBattlerReadyCTB','uvHAU','Charge','getStateTooltipBattler','DzPrC','_scene','hasSvBattler','createTurnOrderCTBGraphicFaceIndex','_ctbTurnOrderVisible','boxWidth','BattleManager_battleSys','26TaiCRS','DisplayOffsetX','eqNws','%1SystemBg','_homeX','3nDCVDb','getCtbCastTimeRate','setCTBGraphicIconIndex','toUpperCase','FaceIndex','applyItemBattleSystemCTBUserEffect','rUJKo','Game_Action_applyItemUserEffect','initMembers','getBattleSystem','Settings','WJrJq','members','placeGauge','onTpbCharged','create','ctbStopped','FYQDx','UpdateFrames','createKeyJS','maKnZ','note','VisuMZ_0_CoreEngine','oAXgo','loadEnemy','JSON','SystemTurnOrderVisibility','isTpbCharged','registerCommand','Mechanics','fontSize','%1BorderColor','IconSet','isSceneBattle','EnemyBattlerFaceName','sort','1953612ayEAAO','createBorderSprite','_ctbTurnOrderFaceIndex','Game_Battler_updateTpbCastTime','changeCtbChargeTime','turn','ActorBattlerIcon','updateOpacity','TotalHorzSprites','prepare','right','_ctbTurnOrderIconIndex','BuZfz','50437tZewSl','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','Game_Action_applyGlobal','DisplayPosition','tpbRelativeSpeed','item','min','xmiqF','version','prototype','TurnOrderCTBGraphicIconIndex','isActor','rotateCTBSprite','Game_Battler_initTpbChargeTime','match','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20keyType\x20=\x20\x27%2\x27;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20position\x20=\x20target.getCurrentTurnOrderPositionCTB();\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20order\x20=\x20position;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(order)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20rate\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20rate\x20to\x20%2\x27.format(\x27\x27,originalValue));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20order\x20=\x20position;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20order;\x0a\x20\x20\x20\x20\x20\x20\x20\x20','onDatabaseLoaded','Rush','faceWidth','%1Mirror','updateTurn','process_VisuMZ_BattleSystemCTB_JS_Notetags','updateTurnCTB','CtbTurnOrderActorFace','appear','ActorBattlerType','oYMfS','rotateDupeNumber','Delay','bitmap','BattleManager_startActorInput','max','fEsBm','compareBattlerSprites','sOjWC','skills','changeCtbCastTime','CtbTurnOrderEnemyIcon','zAuGq','mhcVI','applyCTBPenalty','applyBattleSystemCTBUserEffect','createLetterSprite','repositionLogWindowCTB','exit','updateGraphicHue','name','onRestrict','_tpbState','Game_Battler_updateTpbChargeTime','_anti_CTB_SoftlockCount','Anti-CTB\x20Softlock\x20Count:','updatePadding','SqmPW','KSYek','_fadeDuration','xVQWb','_graphicSv','Window_Help_setItem','parse','tpbRequiredCastTime','_actionBattlers','Game_Battler_tpbRelativeSpeed','(?:GAUGE|TIME|SPEED)','faceHeight','gradientFillRect','setActionState','Actor-%1-%2','_ogWindowLayerX','ARRAYSTRUCT','Class-%1-%2','fQuti','%1PopupText','FgNYf','Game_Battler_updateTpb','Armor-%1-%2','uKAJx','_blendColor','%1BgColor2','updateGraphic','updateSelectionEffect','aMDgA','call','initBattleSystemCTB','loadFace','_isAlive','_positionDuration','_ctbTurnOrderFaceName','kCnwV','initialize','oFgsw','_plural','floor','11123NYkBRC','setItem','Actors','YvCwM','_graphicEnemy','push','Visible','ARRAYJSON','startFade','_position','isPassCTB','isAppeared','applyTpbPenalty','EnemyBattlerIcon','clamp','_positionTargetY','CnZgv','SSZzQ','applyGlobal','setCtbChargeTime','bottom','BorderThickness','DCPGr','_logWindow','checkOpacity','FUNC','Game_Battler_tpbBaseSpeed','canMove','XAyap','TpbSpeedCalcJS','hPuNe','MAX_SAFE_INTEGER','Game_Battler_clearTpbChargeTime','%1FlashDuration','RepositionTopHelpX','getColor','otherCtbChecksPassed','createTurnOrderCTBGraphicType','RegExp','process_VisuMZ_BattleSystemCTB_CreateRegExp','VisuMZ_1_BattleCore','setCtbCastTime','_ctbTurnOrderGraphicType','nSzhs','time','clearTpbChargeTimeCTB','SubjectDistance','EnemyBattlerFontSize','OrderJS','addChild','applyGlobalBattleSystemCTBEffects','ikULY','BattleSystemCTB','ready','casting','VWSbQ','ypFDS','createTurnOrderCTBGraphicIconIndex','KPaQk','tpbChargeTime','isDead','_graphicIconIndex','isBattleSystemCTBTurnOrderVisible','top','isCtbCastingState','Game_BattlerBase_appear','format','isHorz','CtbTurnOrderClearEnemyGraphic','reduce','clearTurnOrderCTBGraphics','isCTB','mUoFT','fLkQC','setCtbAfterSpeed','changeSvActorGraphicBitmap','BattleManager_endAction','SpriteLength'];const _0x46d610=_0x1b58;function _0x1b58(_0x5c93f5,_0x27d9cc){return _0x1b58=function(_0x3fbccc,_0x1b58cf){_0x3fbccc=_0x3fbccc-0x139;let _0x5544a8=_0x3fbc[_0x3fbccc];return _0x5544a8;},_0x1b58(_0x5c93f5,_0x27d9cc);}(function(_0x14de5c,_0x1ef117){const _0x4cd2a0=_0x1b58;while(!![]){try{const _0x36053a=-parseInt(_0x4cd2a0(0x32b))+parseInt(_0x4cd2a0(0x202))*parseInt(_0x4cd2a0(0x307))+-parseInt(_0x4cd2a0(0x1f4))+parseInt(_0x4cd2a0(0x302))*-parseInt(_0x4cd2a0(0x1f1))+parseInt(_0x4cd2a0(0x1ff))+parseInt(_0x4cd2a0(0x18a))*parseInt(_0x4cd2a0(0x2e9))+-parseInt(_0x4cd2a0(0x2a1))*-parseInt(_0x4cd2a0(0x338));if(_0x36053a===_0x1ef117)break;else _0x14de5c['push'](_0x14de5c['shift']());}catch(_0x231d77){_0x14de5c['push'](_0x14de5c['shift']());}}}(_0x3fbc,0xefb98));var label=_0x46d610(0x1be),tier=tier||0x0,dependencies=[_0x46d610(0x31d),_0x46d610(0x1b2)],pluginData=$plugins['filter'](function(_0x9ca8b){const _0x512f96=_0x46d610;return _0x9ca8b[_0x512f96(0x2a8)]&&_0x9ca8b[_0x512f96(0x26f)][_0x512f96(0x2d3)]('['+label+']');})[0x0];VisuMZ[label][_0x46d610(0x311)]=VisuMZ[label][_0x46d610(0x311)]||{},VisuMZ[_0x46d610(0x231)]=function(_0x3346a1,_0x522857){const _0x1ed960=_0x46d610;for(const _0x18f351 in _0x522857){if(_0x1ed960(0x295)===_0x1ed960(0x2ba)){const _0x570c8a=_0x1f5364[_0x1ed960(0x311)];return this[_0x1ed960(0x1cd)]()?_0x570c8a[_0x1ed960(0x1d7)]:_0x570c8a['SpriteThin'];}else{if(_0x18f351['match'](/(.*):(.*)/i)){if(_0x1ed960(0x2f8)!==_0x1ed960(0x165)){const _0x14717e=String(RegExp['$1']),_0x541032=String(RegExp['$2'])[_0x1ed960(0x30a)]()[_0x1ed960(0x2ce)]();let _0x6c046b,_0x18dd2e,_0x18c5c6;switch(_0x541032){case _0x1ed960(0x21b):_0x6c046b=_0x522857[_0x18f351]!==''?Number(_0x522857[_0x18f351]):0x0;break;case _0x1ed960(0x287):_0x18dd2e=_0x522857[_0x18f351]!==''?JSON[_0x1ed960(0x168)](_0x522857[_0x18f351]):[],_0x6c046b=_0x18dd2e[_0x1ed960(0x2c2)](_0x21c15=>Number(_0x21c15));break;case _0x1ed960(0x27d):_0x6c046b=_0x522857[_0x18f351]!==''?eval(_0x522857[_0x18f351]):null;break;case'ARRAYEVAL':_0x18dd2e=_0x522857[_0x18f351]!==''?JSON[_0x1ed960(0x168)](_0x522857[_0x18f351]):[],_0x6c046b=_0x18dd2e[_0x1ed960(0x2c2)](_0x2e0552=>eval(_0x2e0552));break;case _0x1ed960(0x320):_0x6c046b=_0x522857[_0x18f351]!==''?JSON['parse'](_0x522857[_0x18f351]):'';break;case _0x1ed960(0x191):_0x18dd2e=_0x522857[_0x18f351]!==''?JSON[_0x1ed960(0x168)](_0x522857[_0x18f351]):[],_0x6c046b=_0x18dd2e[_0x1ed960(0x2c2)](_0x13488e=>JSON[_0x1ed960(0x168)](_0x13488e));break;case _0x1ed960(0x1a3):_0x6c046b=_0x522857[_0x18f351]!==''?new Function(JSON[_0x1ed960(0x168)](_0x522857[_0x18f351])):new Function('return\x200');break;case _0x1ed960(0x23d):_0x18dd2e=_0x522857[_0x18f351]!==''?JSON[_0x1ed960(0x168)](_0x522857[_0x18f351]):[],_0x6c046b=_0x18dd2e[_0x1ed960(0x2c2)](_0x57adba=>new Function(JSON[_0x1ed960(0x168)](_0x57adba)));break;case _0x1ed960(0x2cc):_0x6c046b=_0x522857[_0x18f351]!==''?String(_0x522857[_0x18f351]):'';break;case _0x1ed960(0x25f):_0x18dd2e=_0x522857[_0x18f351]!==''?JSON[_0x1ed960(0x168)](_0x522857[_0x18f351]):[],_0x6c046b=_0x18dd2e[_0x1ed960(0x2c2)](_0x1e1270=>String(_0x1e1270));break;case'STRUCT':_0x18c5c6=_0x522857[_0x18f351]!==''?JSON[_0x1ed960(0x168)](_0x522857[_0x18f351]):{},_0x6c046b=VisuMZ['ConvertParams']({},_0x18c5c6);break;case _0x1ed960(0x172):_0x18dd2e=_0x522857[_0x18f351]!==''?JSON[_0x1ed960(0x168)](_0x522857[_0x18f351]):[],_0x6c046b=_0x18dd2e[_0x1ed960(0x2c2)](_0xa65471=>VisuMZ[_0x1ed960(0x231)]({},JSON[_0x1ed960(0x168)](_0xa65471)));break;default:continue;}_0x3346a1[_0x14717e]=_0x6c046b;}else _0x23209a[_0x1ed960(0x1be)][_0x1ed960(0x32e)][_0x1ed960(0x17f)](this);}}}return _0x3346a1;},(_0x4bb15c=>{const _0x3552ec=_0x46d610,_0x22a441=_0x4bb15c[_0x3552ec(0x15b)];for(const _0x488303 of dependencies){if(!Imported[_0x488303]){if('DzPrC'!==_0x3552ec(0x2fb))return _0x3552ec(0x1de);else{alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'['format'](_0x22a441,_0x488303)),SceneManager[_0x3552ec(0x159)]();break;}}}const _0x1d6db4=_0x4bb15c[_0x3552ec(0x26f)];if(_0x1d6db4[_0x3552ec(0x13b)](/\[Version[ ](.*?)\]/i)){if(_0x3552ec(0x22d)!==_0x3552ec(0x216)){const _0x5b183a=Number(RegExp['$1']);if(_0x5b183a!==VisuMZ[label][_0x3552ec(0x340)]){if('gAKnQ'!==_0x3552ec(0x209))alert(_0x3552ec(0x339)[_0x3552ec(0x1cc)](_0x22a441,_0x5b183a)),SceneManager[_0x3552ec(0x159)]();else{if(_0x31b8ee[_0x3552ec(0x2aa)](this))return;_0x13aff6[_0x3552ec(0x1be)][_0x3552ec(0x177)]['call'](this);}}}else _0x31da0b['bitmap']=_0x1bfad7[_0x3552ec(0x1f6)](_0x34a9d1[_0x13d52a]);}if(_0x1d6db4[_0x3552ec(0x13b)](/\[Tier[ ](\d+)\]/i)){const _0x2d0927=Number(RegExp['$1']);if(_0x2d0927<tier)alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x3552ec(0x1cc)](_0x22a441,_0x2d0927,tier)),SceneManager['exit']();else{if(_0x3552ec(0x176)==='FgNYf')tier=Math[_0x3552ec(0x14c)](_0x2d0927,tier);else{let _0x7f50ba=_0x54b86a[_0x3552ec(0x1be)]['Settings'][_0x3552ec(0x324)][_0x3552ec(0x1e2)][_0x3552ec(0x17f)](this,this);const _0x356f19=0x0;return _0x7f50ba+_0x356f19;}}}VisuMZ[_0x3552ec(0x231)](VisuMZ[label]['Settings'],_0x4bb15c[_0x3552ec(0x27c)]);})(pluginData),PluginManager[_0x46d610(0x323)](pluginData['name'],'CtbTurnOrderActorIcon',_0x153ef7=>{const _0x13ca00=_0x46d610;VisuMZ[_0x13ca00(0x231)](_0x153ef7,_0x153ef7);const _0x3215e6=_0x153ef7[_0x13ca00(0x18c)],_0x330c1b=_0x153ef7[_0x13ca00(0x2d2)];for(const _0x13e641 of _0x3215e6){if(_0x13ca00(0x251)===_0x13ca00(0x251)){const _0x3b1270=$gameActors[_0x13ca00(0x1e1)](_0x13e641);if(!_0x3b1270)continue;_0x3b1270[_0x13ca00(0x1b4)]=_0x13ca00(0x1de),_0x3b1270[_0x13ca00(0x336)]=_0x330c1b;}else return _0x575d16['BattleSystemCTB'][_0x13ca00(0x1a4)][_0x13ca00(0x17f)](this);}}),PluginManager[_0x46d610(0x323)](pluginData['name'],_0x46d610(0x144),_0x3a0783=>{const _0x20e8eb=_0x46d610;VisuMZ[_0x20e8eb(0x231)](_0x3a0783,_0x3a0783);const _0x404285=_0x3a0783[_0x20e8eb(0x18c)],_0x4b1085=_0x3a0783[_0x20e8eb(0x2c6)],_0x422639=_0x3a0783['FaceIndex'];for(const _0x40ba84 of _0x404285){if(_0x20e8eb(0x225)==='KHjpR'){const _0x14d698=$gameActors[_0x20e8eb(0x1e1)](_0x40ba84);if(!_0x14d698)continue;_0x14d698[_0x20e8eb(0x1b4)]=_0x20e8eb(0x2d8),_0x14d698[_0x20e8eb(0x184)]=_0x4b1085,_0x14d698[_0x20e8eb(0x32d)]=_0x422639;}else{if(this[_0x20e8eb(0x166)]!==_0x1300f7[_0x20e8eb(0x2b4)]())return this[_0x20e8eb(0x25e)]();}}}),PluginManager[_0x46d610(0x323)](pluginData[_0x46d610(0x15b)],'CtbTurnOrderClearActorGraphic',_0x2343bf=>{const _0x522814=_0x46d610;VisuMZ[_0x522814(0x231)](_0x2343bf,_0x2343bf);const _0x35b2c6=_0x2343bf['Actors'];for(const _0x5b3eee of _0x35b2c6){if('HdpLH'===_0x522814(0x23c)){const _0x48dfe9=this[_0x522814(0x1e1)]()[_0x522814(0x31c)];if(_0x48dfe9[_0x522814(0x13b)](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i))return _0x4b4041(_0x32c9f5['$2']);return this[_0x522814(0x2c0)]();}else{const _0x4f9eca=$gameActors[_0x522814(0x1e1)](_0x5b3eee);if(!_0x4f9eca)continue;_0x4f9eca[_0x522814(0x1d0)]();}}}),PluginManager[_0x46d610(0x323)](pluginData['name'],_0x46d610(0x152),_0x3d8716=>{const _0xf400ba=_0x46d610;VisuMZ[_0xf400ba(0x231)](_0x3d8716,_0x3d8716);const _0x30ba2e=_0x3d8716[_0xf400ba(0x25a)],_0x28b3d4=_0x3d8716[_0xf400ba(0x2d2)];for(const _0x9b3a85 of _0x30ba2e){const _0x39e70c=$gameTroop[_0xf400ba(0x313)]()[_0x9b3a85];if(!_0x39e70c)continue;_0x39e70c[_0xf400ba(0x1b4)]='icon',_0x39e70c[_0xf400ba(0x336)]=_0x28b3d4;}}),PluginManager[_0x46d610(0x323)](pluginData[_0x46d610(0x15b)],_0x46d610(0x1eb),_0x2ab6d7=>{const _0x217d0e=_0x46d610;VisuMZ['ConvertParams'](_0x2ab6d7,_0x2ab6d7);const _0x3ad2b2=_0x2ab6d7[_0x217d0e(0x25a)],_0x85a51e=_0x2ab6d7['FaceName'],_0x50a60c=_0x2ab6d7[_0x217d0e(0x30b)];for(const _0x4a1d00 of _0x3ad2b2){const _0x1f0644=$gameTroop[_0x217d0e(0x313)]()[_0x4a1d00];if(!_0x1f0644)continue;_0x1f0644['_ctbTurnOrderGraphicType']=_0x217d0e(0x2d8),_0x1f0644[_0x217d0e(0x184)]=_0x85a51e,_0x1f0644[_0x217d0e(0x32d)]=_0x50a60c;}}),PluginManager['registerCommand'](pluginData['name'],_0x46d610(0x1ce),_0x544bdc=>{const _0x23dde6=_0x46d610;VisuMZ[_0x23dde6(0x231)](_0x544bdc,_0x544bdc);const _0x4eb112=_0x544bdc[_0x23dde6(0x25a)];for(const _0x293c46 of _0x4eb112){const _0x345965=$gameTroop[_0x23dde6(0x313)]()[_0x293c46];if(!_0x345965)continue;_0x345965[_0x23dde6(0x1d0)]();}}),PluginManager[_0x46d610(0x323)](pluginData[_0x46d610(0x15b)],_0x46d610(0x321),_0x26a334=>{const _0x61e2ba=_0x46d610;VisuMZ['ConvertParams'](_0x26a334,_0x26a334);const _0x62a3e2=_0x26a334[_0x61e2ba(0x190)];$gameSystem[_0x61e2ba(0x25c)](_0x62a3e2);}),VisuMZ['BattleSystemCTB'][_0x46d610(0x208)]=Scene_Boot['prototype'][_0x46d610(0x13d)],Scene_Boot['prototype'][_0x46d610(0x13d)]=function(){const _0x296980=_0x46d610;this[_0x296980(0x1b1)](),VisuMZ[_0x296980(0x1be)][_0x296980(0x208)][_0x296980(0x17f)](this),this[_0x296980(0x142)]();},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x1b0)]={},Scene_Boot[_0x46d610(0x341)][_0x46d610(0x1b1)]=function(){const _0x54a3f8=_0x46d610,_0x56160d=VisuMZ[_0x54a3f8(0x1be)][_0x54a3f8(0x1b0)],_0x1e255f='<JS\x20%2\x20%1\x20%3>\x5cs*([\x5cs\x5cS]*)\x5cs*<\x5c/JS\x20%2\x20%1\x20%3>',_0x1df3cf=[_0x54a3f8(0x2f9),_0x54a3f8(0x2cb),'After'];for(const _0x333db0 of _0x1df3cf){if('EbsbH'===_0x54a3f8(0x226))_0x48a0e6[_0x54a3f8(0x1be)][_0x54a3f8(0x296)][_0x54a3f8(0x17f)](this),_0x1a7be2[_0x54a3f8(0x1f3)]();else{const _0x665b9d=_0x1e255f[_0x54a3f8(0x1cc)](_0x333db0[_0x54a3f8(0x30a)]()[_0x54a3f8(0x2ce)](),_0x54a3f8(0x1ea),_0x54a3f8(0x16c)),_0x27f7c6=new RegExp(_0x665b9d,'i');VisuMZ[_0x54a3f8(0x1be)][_0x54a3f8(0x1b0)][_0x333db0]=_0x27f7c6;}}VisuMZ['BattleSystemCTB']['RegExp']['OrderJS']=/<JS (?:CTB) (?:ORDER|DELAY|RUSH|SHIFT)>\s*([\s\S]*)\s*<\/JS (?:CTB) (?:ORDER|DELAY|RUSH|SHIFT)>/i;},Scene_Boot['prototype'][_0x46d610(0x142)]=function(){const _0x591c97=_0x46d610;if(VisuMZ[_0x591c97(0x23f)])return;const _0x30809d=$dataSkills[_0x591c97(0x228)]($dataItems);for(const _0x2924b0 of _0x30809d){if(_0x591c97(0x2bb)===_0x591c97(0x2bb)){if(!_0x2924b0)continue;VisuMZ['BattleSystemCTB'][_0x591c97(0x2da)](_0x2924b0);}else{const _0x2a50f5=_0x2f8174[_0x591c97(0x1be)][_0x591c97(0x31a)](this[_0x591c97(0x33d)](),'Charge');if(_0x4bbc87[_0x591c97(0x1be)]['JS'][_0x2a50f5]){const _0x29ed1f=_0x3cf30f['BattleSystemCTB']['JS'][_0x2a50f5][_0x591c97(0x17f)](this,this[_0x591c97(0x213)](),_0x9abd7);_0x399932['setCtbChargeTime'](_0x29ed1f);}_0x28e9cf['match'](/<(?:CTB) CHARGE (?:GAUGE|TIME|SPEED):[ ](\d+)([%％])>/i)&&_0x26a302[_0x591c97(0x19d)](_0x481e60(_0x1741ed['$1'])*0.01),_0x3a1b53['match'](/<(?:CTB) CHARGE (?:GAUGE|TIME|SPEED):[ ]([\+\-]\d+)([%％])>/i)&&_0x24bbde['changeCtbChargeTime'](_0x78466f(_0x25fbaa['$1'])*0.01);}}},VisuMZ[_0x46d610(0x1be)]['ParseSkillNotetags']=VisuMZ[_0x46d610(0x230)],VisuMZ[_0x46d610(0x230)]=function(_0x21f32c){const _0x2f2f44=_0x46d610;VisuMZ[_0x2f2f44(0x1be)]['ParseSkillNotetags'][_0x2f2f44(0x17f)](this,_0x21f32c),VisuMZ[_0x2f2f44(0x1be)][_0x2f2f44(0x2da)](_0x21f32c);},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x2f1)]=VisuMZ[_0x46d610(0x2f1)],VisuMZ[_0x46d610(0x2f1)]=function(_0x48d109){const _0x11e6ba=_0x46d610;VisuMZ[_0x11e6ba(0x1be)][_0x11e6ba(0x2f1)][_0x11e6ba(0x17f)](this,_0x48d109),VisuMZ[_0x11e6ba(0x1be)][_0x11e6ba(0x2da)](_0x48d109);},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x2da)]=function(_0x5a12a6){const _0x507152=_0x46d610,_0x598998=[_0x507152(0x2f9),'Cast','After'];for(const _0x559af0 of _0x598998){VisuMZ['BattleSystemCTB'][_0x507152(0x22a)](_0x5a12a6,_0x559af0);}VisuMZ['BattleSystemCTB']['createOrderJS'](_0x5a12a6,_0x507152(0x29b));},VisuMZ[_0x46d610(0x1be)]['JS']={},VisuMZ[_0x46d610(0x1be)]['createRateJS']=function(_0x4a8cdd,_0x1b419f){const _0x5a98dd=_0x46d610,_0x5b38f4=_0x4a8cdd[_0x5a98dd(0x31c)];if(_0x5b38f4[_0x5a98dd(0x13b)](VisuMZ[_0x5a98dd(0x1be)][_0x5a98dd(0x1b0)][_0x1b419f])){const _0x4d27af=String(RegExp['$1']),_0x5843ea=_0x5a98dd(0x20d)[_0x5a98dd(0x1cc)](_0x4d27af,_0x1b419f),_0x5b106a=VisuMZ[_0x5a98dd(0x1be)]['createKeyJS'](_0x4a8cdd,_0x1b419f);VisuMZ['BattleSystemCTB']['JS'][_0x5b106a]=new Function(_0x5843ea);}},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x1d8)]=function(_0x3c07a8,_0x1ee959){const _0x5aa8e0=_0x46d610,_0xda2fee=_0x3c07a8[_0x5aa8e0(0x31c)];if(_0xda2fee[_0x5aa8e0(0x13b)](VisuMZ[_0x5aa8e0(0x1be)]['RegExp'][_0x5aa8e0(0x1ba)])){if(_0x5aa8e0(0x14f)!==_0x5aa8e0(0x14f))this['initialize'](...arguments);else{const _0x3489c0=String(RegExp['$1']),_0x4aa9ba=_0x5aa8e0(0x13c)[_0x5aa8e0(0x1cc)](_0x3489c0,_0x1ee959),_0x2e78d5=VisuMZ['BattleSystemCTB'][_0x5aa8e0(0x31a)](_0x3c07a8,_0x1ee959);VisuMZ[_0x5aa8e0(0x1be)]['JS'][_0x2e78d5]=new Function(_0x4aa9ba);}}},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x31a)]=function(_0x570f73,_0x51b5ca){const _0x324aba=_0x46d610;let _0x154df1='';if($dataActors[_0x324aba(0x2d3)](_0x570f73))_0x154df1=_0x324aba(0x170)[_0x324aba(0x1cc)](_0x570f73['id'],_0x51b5ca);if($dataClasses[_0x324aba(0x2d3)](_0x570f73))_0x154df1=_0x324aba(0x173)[_0x324aba(0x1cc)](_0x570f73['id'],_0x51b5ca);if($dataSkills['includes'](_0x570f73))_0x154df1='Skill-%1-%2'[_0x324aba(0x1cc)](_0x570f73['id'],_0x51b5ca);if($dataItems[_0x324aba(0x2d3)](_0x570f73))_0x154df1='Item-%1-%2'['format'](_0x570f73['id'],_0x51b5ca);if($dataWeapons[_0x324aba(0x2d3)](_0x570f73))_0x154df1=_0x324aba(0x218)[_0x324aba(0x1cc)](_0x570f73['id'],_0x51b5ca);if($dataArmors['includes'](_0x570f73))_0x154df1='Armor-%1-%2'[_0x324aba(0x1cc)](_0x570f73['id'],_0x51b5ca);if($dataEnemies[_0x324aba(0x2d3)](_0x570f73))_0x154df1='Enemy-%1-%2'[_0x324aba(0x1cc)](_0x570f73['id'],_0x51b5ca);if($dataStates[_0x324aba(0x2d3)](_0x570f73))_0x154df1=_0x324aba(0x2cd)[_0x324aba(0x1cc)](_0x570f73['id'],_0x51b5ca);return _0x154df1;},VisuMZ[_0x46d610(0x1be)]['BattleManager_battleSys']=BattleManager[_0x46d610(0x2a0)],BattleManager['battleSys']=function(){const _0x4fd63b=_0x46d610;if(this['isCTB']())return'CTB';return VisuMZ[_0x4fd63b(0x1be)][_0x4fd63b(0x301)][_0x4fd63b(0x17f)](this);},BattleManager['isCTB']=function(){const _0x47f996=_0x46d610;return $gameSystem[_0x47f996(0x310)]()==='CTB';},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x2e4)]=BattleManager[_0x46d610(0x279)],BattleManager['isTpb']=function(){const _0x4bcb09=_0x46d610;if(this[_0x4bcb09(0x1d1)]())return!![];return VisuMZ[_0x4bcb09(0x1be)]['BattleManager_isTpb'][_0x4bcb09(0x17f)](this);},VisuMZ['BattleSystemCTB']['BattleManager_isActiveTpb']=BattleManager[_0x46d610(0x1ed)],BattleManager[_0x46d610(0x1ed)]=function(){const _0x2918bf=_0x46d610;if(this[_0x2918bf(0x1d1)]())return![];return VisuMZ['BattleSystemCTB'][_0x2918bf(0x240)][_0x2918bf(0x17f)](this);},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x2c7)]=BattleManager['updateTurn'],BattleManager[_0x46d610(0x141)]=function(_0x2e01d6){const _0x31bd4d=_0x46d610;this['isCTB']()?this[_0x31bd4d(0x143)](_0x2e01d6):VisuMZ['BattleSystemCTB'][_0x31bd4d(0x2c7)][_0x31bd4d(0x17f)](this,_0x2e01d6);},BattleManager[_0x46d610(0x143)]=function(_0x3ee14b){const _0x5d9d8d=_0x46d610;$gameParty['requestMotionRefresh']();for(;;){if(this[_0x5d9d8d(0x2f7)]())break;_0x3ee14b&&(_0x5d9d8d(0x19a)===_0x5d9d8d(0x278)?_0x4ef3bd[_0x5d9d8d(0x1be)][_0x5d9d8d(0x13a)][_0x5d9d8d(0x17f)](this,_0xdffa8d):this[_0x5d9d8d(0x1e6)]());!this[_0x5d9d8d(0x219)]&&(_0x5d9d8d(0x212)===_0x5d9d8d(0x212)?this[_0x5d9d8d(0x219)]=this[_0x5d9d8d(0x2f2)]():this[_0x5d9d8d(0x1d1)]()?this[_0x5d9d8d(0x143)](_0x33fd32):_0x118d28['BattleSystemCTB']['BattleManager_updateTurn'][_0x5d9d8d(0x17f)](this,_0x542d3a));this[_0x5d9d8d(0x219)]&&(this[_0x5d9d8d(0x274)](),this[_0x5d9d8d(0x1f3)]());if(VisuMZ[_0x5d9d8d(0x1be)][_0x5d9d8d(0x311)][_0x5d9d8d(0x324)][_0x5d9d8d(0x285)])break;}this['checkCtbAntiSoftlock']();},VisuMZ[_0x46d610(0x1be)]['BattleManager_processTurn']=BattleManager['processTurn'],BattleManager['processTurn']=function(){const _0x7a6266=_0x46d610;this['isCTB']()?this[_0x7a6266(0x293)]():VisuMZ['BattleSystemCTB'][_0x7a6266(0x2de)][_0x7a6266(0x17f)](this);},BattleManager[_0x46d610(0x293)]=function(){const _0x1969e9=_0x46d610,_0x25ae51=this[_0x1969e9(0x219)],_0x517a2e=_0x25ae51[_0x1969e9(0x222)]();if(_0x517a2e){_0x517a2e[_0x1969e9(0x334)]();if(_0x517a2e[_0x1969e9(0x2af)]()){if('FKeeV'===_0x1969e9(0x1ef))return this[_0x1969e9(0x25e)]();else this['startAction'](),_0x25ae51[_0x1969e9(0x200)]();}else{if(_0x1969e9(0x1c1)===_0x1969e9(0x31b))return this[_0x1969e9(0x25e)]();else _0x25ae51[_0x1969e9(0x200)](),_0x25ae51[_0x1969e9(0x1d4)](0x0),this['endAction'](),this[_0x1969e9(0x219)]=null;}}else'dmSCk'==='ejXxD'?(this['x']=this[_0x1969e9(0x281)],this['y']=this[_0x1969e9(0x199)],this[_0x1969e9(0x294)]<=0x0&&!this[_0x1969e9(0x2e8)]&&this[_0x1969e9(0x192)](0xff)):(_0x25ae51[_0x1969e9(0x1d4)](0x0),this['endAction'](),this[_0x1969e9(0x219)]=null);},BattleManager['isAnyBattlerReadyCTB']=function(){const _0x56d017=_0x46d610;if(this[_0x56d017(0x219)])return!![];if(this[_0x56d017(0x2ab)]!==_0x56d017(0x330))return!![];if(this[_0x56d017(0x2a4)]())return!![];if(this[_0x56d017(0x261)])return![];const _0x1a8ddc=this[_0x56d017(0x223)]()[_0x56d017(0x242)](_0x337e88=>_0x337e88&&_0x337e88[_0x56d017(0x195)]());return _0x1a8ddc[_0x56d017(0x1f9)](_0x44b4dd=>_0x44b4dd[_0x56d017(0x194)]());},Game_Battler[_0x46d610(0x341)][_0x46d610(0x194)]=function(){const _0x1848c0=_0x46d610;if(this[_0x1848c0(0x322)]())return!![];if(this[_0x1848c0(0x217)]())return!![];if(this[_0x1848c0(0x2cf)]())return!![];return![];},BattleManager[_0x46d610(0x1e7)]=function(){const _0x1ce371=_0x46d610;let _0x4178ef=VisuMZ[_0x1ce371(0x1be)][_0x1ce371(0x311)][_0x1ce371(0x324)][_0x1ce371(0x285)]?0x1e:0xa;if(this[_0x1ce371(0x2f7)]()&&this[_0x1ce371(0x1ae)]()){if(_0x1ce371(0x1e3)!==_0x1ce371(0x1e3))return _0x2fd37e(_0x544d7d['$2']);else{this[_0x1ce371(0x15f)]=this['_anti_CTB_SoftlockCount']||0x0,this['_anti_CTB_SoftlockCount']++;if(this[_0x1ce371(0x15f)]>=_0x4178ef){if('coZiX'!=='grlwJ')this[_0x1ce371(0x282)]();else return _0x2a5c0e['x']-_0x22c744['x'];}}}else this[_0x1ce371(0x15f)]=0x0;},BattleManager['otherCtbChecksPassed']=function(){const _0x376fc4=_0x46d610;if(this[_0x376fc4(0x219)])return![];if(this['_phase']!==_0x376fc4(0x330))return![];if(this[_0x376fc4(0x2a4)]())return![];return!![];},BattleManager[_0x46d610(0x282)]=function(){const _0x5e772b=_0x46d610;$gameTemp['isPlaytest']()&&console[_0x5e772b(0x27a)](_0x5e772b(0x160),this['_anti_CTB_SoftlockCount']);for(const _0x3a4ff2 of this['allBattleMembers']()){if(!_0x3a4ff2)continue;_0x3a4ff2[_0x5e772b(0x2bc)]()&&(_0x3a4ff2[_0x5e772b(0x16f)](_0x5e772b(0x2d0)),_0x3a4ff2['_tpbState']=_0x5e772b(0x247));}this[_0x5e772b(0x219)]=null,this[_0x5e772b(0x2ab)]=_0x5e772b(0x330),this[_0x5e772b(0x24c)]=![];},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x237)]=BattleManager['updateAllTpbBattlers'],BattleManager[_0x46d610(0x258)]=function(){const _0x3e9036=_0x46d610;if(this['isCTB']()){if('dUisT'!==_0x3e9036(0x2df))return _0x24b5b5[_0x3e9036(0x2a8)]&&_0x38d6f0['description'][_0x3e9036(0x2d3)]('['+_0x52ffaa+']');else this[_0x3e9036(0x20a)]();}else VisuMZ[_0x3e9036(0x1be)][_0x3e9036(0x237)]['call'](this);},BattleManager[_0x46d610(0x20a)]=function(){const _0x1d2728=_0x46d610,_0x53bfbe=this['allBattleMembers']();_0x53bfbe['sort']((_0x117f02,_0x373fa4)=>{const _0x10f107=_0x1b58;if('kPKCv'!==_0x10f107(0x163))return _0x117f02['ctbTicksToGoal'](0x1)-_0x373fa4[_0x10f107(0x24a)](0x1);else{const _0x4ed8f1=_0x19ed25['Settings'];return this[_0x10f107(0x1cd)]()?_0x4ed8f1[_0x10f107(0x2b6)]:_0x4ed8f1[_0x10f107(0x1d7)];}});for(const _0x3b6dd1 of _0x53bfbe){this[_0x1d2728(0x28f)](_0x3b6dd1);}},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x262)]=BattleManager[_0x46d610(0x284)],BattleManager['startBattle']=function(){const _0x56e7b4=_0x46d610;VisuMZ[_0x56e7b4(0x1be)][_0x56e7b4(0x262)][_0x56e7b4(0x17f)](this),this['updateTurnOrderCTB'](!![]);},VisuMZ[_0x46d610(0x1be)]['BattleManager_endAction']=BattleManager[_0x46d610(0x265)],BattleManager[_0x46d610(0x265)]=function(){const _0x62616b=_0x46d610;this[_0x62616b(0x2ca)](),VisuMZ[_0x62616b(0x1be)][_0x62616b(0x1d6)]['call'](this),this[_0x62616b(0x288)]();},BattleManager[_0x46d610(0x2ca)]=function(){const _0x324b22=_0x46d610;if(!this[_0x324b22(0x1d1)]())return;this[_0x324b22(0x219)]&&this[_0x324b22(0x219)]['numActions']()<=0x0&&(this['rotateCTBSprites'](),this['_subject'][_0x324b22(0x16f)](_0x324b22(0x2d0)));},BattleManager[_0x46d610(0x288)]=function(){const _0x2965ca=_0x46d610;if(!this[_0x2965ca(0x1d1)]())return;this[_0x2965ca(0x1f3)](),this[_0x2965ca(0x219)]&&this[_0x2965ca(0x274)]();},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x14b)]=BattleManager[_0x46d610(0x2b8)],BattleManager[_0x46d610(0x2b8)]=function(){const _0x33158a=_0x46d610;this[_0x33158a(0x1f3)](),VisuMZ[_0x33158a(0x1be)][_0x33158a(0x14b)][_0x33158a(0x17f)](this);},BattleManager['updateTurnOrderCTB']=function(_0x46fa24){const _0x2f2a3e=_0x46d610;if(!this['isCTB']())return;const _0x3418b3=SceneManager[_0x2f2a3e(0x2fc)][_0x2f2a3e(0x252)];if(!_0x3418b3)return;_0x3418b3[_0x2f2a3e(0x24e)](_0x46fa24);},BattleManager[_0x46d610(0x2f6)]=function(){const _0x1cc565=_0x46d610;if(!this[_0x1cc565(0x1d1)]())return;const _0x317550=SceneManager[_0x1cc565(0x2fc)][_0x1cc565(0x252)];if(!_0x317550)return;_0x317550['rotateCTBSprite'](this[_0x1cc565(0x219)]);},VisuMZ['BattleSystemCTB'][_0x46d610(0x238)]=Game_System[_0x46d610(0x341)][_0x46d610(0x186)],Game_System[_0x46d610(0x341)]['initialize']=function(){const _0x3bb3ed=_0x46d610;VisuMZ[_0x3bb3ed(0x1be)][_0x3bb3ed(0x238)]['call'](this),this[_0x3bb3ed(0x180)]();},Game_System['prototype'][_0x46d610(0x180)]=function(){const _0x336f19=_0x46d610;this[_0x336f19(0x2ff)]=!![];},Game_System[_0x46d610(0x341)][_0x46d610(0x1c8)]=function(){const _0x27c804=_0x46d610;return this['_ctbTurnOrderVisible']===undefined&&this[_0x27c804(0x180)](),this[_0x27c804(0x2ff)];},Game_System['prototype'][_0x46d610(0x25c)]=function(_0xe6dc1a){const _0x2cccb2=_0x46d610;this[_0x2cccb2(0x2ff)]===undefined&&this[_0x2cccb2(0x180)](),this[_0x2cccb2(0x2ff)]=_0xe6dc1a;},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x30e)]=Game_Action['prototype']['applyItemUserEffect'],Game_Action[_0x46d610(0x341)][_0x46d610(0x1ee)]=function(_0x3f01ff){const _0x2e5d27=_0x46d610;VisuMZ['BattleSystemCTB'][_0x2e5d27(0x30e)]['call'](this,_0x3f01ff),this[_0x2e5d27(0x156)](_0x3f01ff);},Game_Action['prototype'][_0x46d610(0x156)]=function(_0x200905){const _0x366c67=_0x46d610;if(!SceneManager['isSceneBattle']())return;if(!BattleManager['isCTB']())return;if(this[_0x366c67(0x33d)]())this['applyItemBattleSystemCTBUserEffect'](_0x200905);},Game_Action[_0x46d610(0x341)][_0x46d610(0x30c)]=function(_0xb5f0f9){const _0x13305d=_0x46d610,_0x58f4d9=this['item']()[_0x13305d(0x31c)];if(_0xb5f0f9[_0x13305d(0x2ea)]()){if(_0x13305d(0x255)===_0x13305d(0x220)){if(!_0x1b83b9[_0x13305d(0x1d1)]())return;if(!_0x443052[_0x13305d(0x328)]())return;if(this===_0x1835ce[_0x13305d(0x1e1)]())return;if(this===_0x169430[_0x13305d(0x219)])return;_0x176fc7=_0x4f3339['max'](_0x6e5baf,0x1),this['processTurnOrderChangeCTB'](_0x2d71bc);}else{const _0x2d21d4=VisuMZ['BattleSystemCTB']['createKeyJS'](this[_0x13305d(0x33d)](),_0x13305d(0x2f9));if(VisuMZ[_0x13305d(0x1be)]['JS'][_0x2d21d4]){const _0x18c42b=VisuMZ['BattleSystemCTB']['JS'][_0x2d21d4][_0x13305d(0x17f)](this,this[_0x13305d(0x213)](),_0xb5f0f9);_0xb5f0f9[_0x13305d(0x19d)](_0x18c42b);}_0x58f4d9[_0x13305d(0x13b)](/<(?:CTB) CHARGE (?:GAUGE|TIME|SPEED):[ ](\d+)([%％])>/i)&&_0xb5f0f9[_0x13305d(0x19d)](Number(RegExp['$1'])*0.01),_0x58f4d9[_0x13305d(0x13b)](/<(?:CTB) CHARGE (?:GAUGE|TIME|SPEED):[ ]([\+\-]\d+)([%％])>/i)&&_0xb5f0f9[_0x13305d(0x32f)](Number(RegExp['$1'])*0.01);}}else{if(_0xb5f0f9[_0x13305d(0x1ca)]()){if('BuZfz'===_0x13305d(0x337)){const _0x5535cf=VisuMZ[_0x13305d(0x1be)][_0x13305d(0x31a)](this[_0x13305d(0x33d)](),_0x13305d(0x2cb));if(VisuMZ['BattleSystemCTB']['JS'][_0x5535cf]){if('HPhKm'==='HPhKm'){const _0x403390=VisuMZ[_0x13305d(0x1be)]['JS'][_0x5535cf]['call'](this,this[_0x13305d(0x213)](),_0xb5f0f9);_0xb5f0f9['setCtbCastTime'](_0x403390);}else return this[_0x13305d(0x1b4)]===_0x1bb712&&(this[_0x13305d(0x1b4)]=this['createTurnOrderCTBGraphicType']()),this[_0x13305d(0x1b4)];}_0x58f4d9[_0x13305d(0x13b)](/<(?:CTB) CAST (?:GAUGE|TIME|SPEED):[ ](\d+)([%％])>/i)&&_0xb5f0f9[_0x13305d(0x1b3)](Number(RegExp['$1'])*0.01);if(_0x58f4d9[_0x13305d(0x13b)](/<(?:CTB) CAST (?:GAUGE|TIME|SPEED):[ ]([\+\-]\d+)([%％])>/i)){if(_0x13305d(0x185)===_0x13305d(0x1a6))for(let _0x563c9c=0x0;_0x563c9c<_0x29221a;_0x563c9c++){const _0x3f6a1e=new _0x3c5689(_0x3b0710,_0xb5e02f,_0x563c9c);this[_0x13305d(0x22f)][_0x13305d(0x1bb)](_0x3f6a1e),this[_0x13305d(0x235)][_0x13305d(0x18f)](_0x3f6a1e);}else _0xb5f0f9[_0x13305d(0x151)](Number(RegExp['$1'])*0.01);}}else this[_0x13305d(0x184)]=this[_0x13305d(0x207)]();}}const _0x1905d6=VisuMZ[_0x13305d(0x1be)][_0x13305d(0x31a)](this['item'](),_0x13305d(0x29b));if(VisuMZ[_0x13305d(0x1be)]['JS'][_0x1905d6]){if(_0x13305d(0x26a)!==_0x13305d(0x26a)){let _0x45209c=_0x20aad7[_0x13305d(0x1be)][_0x13305d(0x311)][_0x13305d(0x324)][_0x13305d(0x285)]?0x1e:0xa;this[_0x13305d(0x2f7)]()&&this['otherCtbChecksPassed']()?(this[_0x13305d(0x15f)]=this[_0x13305d(0x15f)]||0x0,this[_0x13305d(0x15f)]++,this[_0x13305d(0x15f)]>=_0x45209c&&this[_0x13305d(0x282)]()):this[_0x13305d(0x15f)]=0x0;}else{const _0xf7d288=VisuMZ['BattleSystemCTB']['JS'][_0x1905d6]['call'](this,this['subject'](),_0xb5f0f9);_0xb5f0f9['setTurnOrderCTB'](_0xf7d288);}}_0x58f4d9[_0x13305d(0x13b)](/<(?:CTB) (?:SET|MAKE|EXACT) ORDER:[ ](\d+)>/i)&&_0xb5f0f9[_0x13305d(0x2d9)](Number(RegExp['$1'])),_0x58f4d9[_0x13305d(0x13b)](/<(?:CTB) (?:CHANGE|DELAY|RUSH|SHIFT) ORDER:[ ]([\+\-]\d+)>/i)&&_0xb5f0f9[_0x13305d(0x1e4)](Number(RegExp['$1']));},VisuMZ['BattleSystemCTB'][_0x46d610(0x33a)]=Game_Action['prototype'][_0x46d610(0x19c)],Game_Action[_0x46d610(0x341)][_0x46d610(0x19c)]=function(){const _0x5bb037=_0x46d610;VisuMZ[_0x5bb037(0x1be)][_0x5bb037(0x33a)][_0x5bb037(0x17f)](this),this['applyGlobalBattleSystemCTBEffects']();},Game_Action[_0x46d610(0x341)][_0x46d610(0x1bc)]=function(){const _0x3b0897=_0x46d610;if(!this[_0x3b0897(0x33d)]())return;if(!BattleManager[_0x3b0897(0x1d1)]())return;const _0x223fce=this[_0x3b0897(0x33d)]()[_0x3b0897(0x31c)];let _0x194833=0x0;this['_forcing']&&(_0x3b0897(0x1a8)!=='FqOUl'?_0x194833=this[_0x3b0897(0x213)]()[_0x3b0897(0x215)]:this[_0x3b0897(0x273)]=this[_0x3b0897(0x169)]()-_0x20305b);const _0x7d81d9=VisuMZ['BattleSystemCTB'][_0x3b0897(0x31a)](this[_0x3b0897(0x33d)](),'After');VisuMZ[_0x3b0897(0x1be)]['JS'][_0x7d81d9]&&(_0x194833+=VisuMZ[_0x3b0897(0x1be)]['JS'][_0x7d81d9][_0x3b0897(0x17f)](this,this[_0x3b0897(0x213)](),this['subject']()));let _0x1d74e8=this[_0x3b0897(0x33d)]()[_0x3b0897(0x28e)]>0x0?this[_0x3b0897(0x33d)]()[_0x3b0897(0x28e)]:0x0;if(this[_0x3b0897(0x27e)]())_0x1d74e8+=this[_0x3b0897(0x213)]()[_0x3b0897(0x2f3)]();_0x194833+=(_0x1d74e8/0xfa0)[_0x3b0897(0x198)](0x0,0x1);this[_0x3b0897(0x33d)]()[_0x3b0897(0x31c)][_0x3b0897(0x13b)](/<(?:CTB) AFTER (?:GAUGE|TIME|SPEED):[ ](\d+)([%％])>/i)&&(_0x194833+=Number(RegExp['$1'])*0.01);const _0x181b3f=this[_0x3b0897(0x213)]()[_0x3b0897(0x291)]()[_0x3b0897(0x228)](this[_0x3b0897(0x213)]()[_0x3b0897(0x150)]()),_0x20651e=/<(?:CTB) AFTER (?:GAUGE|TIME|SPEED):[ ]([\+\-]\d+)([%％])>/i,_0x16c687=_0x181b3f[_0x3b0897(0x2c2)](_0x4804b7=>_0x4804b7&&_0x4804b7[_0x3b0897(0x31c)][_0x3b0897(0x13b)](_0x20651e)?Number(RegExp['$1'])*0.01:0x0);_0x194833=_0x16c687[_0x3b0897(0x1cf)]((_0x5e6b8b,_0x1f83b8)=>_0x5e6b8b+_0x1f83b8,_0x194833),this[_0x3b0897(0x213)]()['setCtbAfterSpeed'](_0x194833);},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x19d)]=function(_0x16ed6a){const _0x133521=_0x46d610;this[_0x133521(0x215)]=_0x16ed6a;},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x32f)]=function(_0x1a36b3){const _0x42e92f=_0x46d610;this[_0x42e92f(0x19d)](this[_0x42e92f(0x215)]+_0x1a36b3);},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x1b3)]=function(_0x140f69){const _0x38c416=_0x46d610,_0x295aea=this['tpbRequiredCastTime']();this[_0x38c416(0x273)]=_0x295aea*_0x140f69;},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x151)]=function(_0x5242da){const _0x335ec1=_0x46d610,_0x2b9d6f=this[_0x335ec1(0x169)](),_0x5dea50=_0x2b9d6f*_0x5242da;this[_0x335ec1(0x273)]=this['_tpbCastTime']+_0x5dea50;},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x1cb)]=Game_BattlerBase['prototype']['appear'],Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x145)]=function(){const _0x1d6bdc=_0x46d610;VisuMZ['BattleSystemCTB'][_0x1d6bdc(0x1cb)][_0x1d6bdc(0x17f)](this),BattleManager[_0x1d6bdc(0x1f3)]();},VisuMZ[_0x46d610(0x1be)]['Game_BattlerBase_hide']=Game_BattlerBase[_0x46d610(0x341)]['hide'],Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x2dd)]=function(){const _0x513ea3=_0x46d610;VisuMZ[_0x513ea3(0x1be)][_0x513ea3(0x296)][_0x513ea3(0x17f)](this),BattleManager['updateTurnOrderCTB']();},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x1d0)]=function(){const _0x2f53d3=_0x46d610;delete this['_ctbTurnOrderGraphicType'],delete this[_0x2f53d3(0x184)],delete this['_ctbTurnOrderFaceIndex'],delete this['_ctbTurnOrderIconIndex'];},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x214)]=function(){const _0x35de13=_0x46d610;return this[_0x35de13(0x1b4)]===undefined&&(this[_0x35de13(0x1b4)]=this['createTurnOrderCTBGraphicType']()),this[_0x35de13(0x1b4)];},Game_BattlerBase['prototype'][_0x46d610(0x1af)]=function(){const _0x43f6cb=_0x46d610;return Window_CTB_TurnOrder[_0x43f6cb(0x311)]['EnemyBattlerType'];},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x286)]=function(){const _0x2b6d5d=_0x46d610;return this[_0x2b6d5d(0x184)]===undefined&&(_0x2b6d5d(0x254)!==_0x2b6d5d(0x254)?(_0x77f281['setCtbAfterSpeed'](0x0),this[_0x2b6d5d(0x265)](),this['_subject']=null):this[_0x2b6d5d(0x184)]=this[_0x2b6d5d(0x207)]()),this[_0x2b6d5d(0x184)];},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x207)]=function(){const _0x2b03ae=_0x46d610;return Window_CTB_TurnOrder[_0x2b03ae(0x311)][_0x2b03ae(0x329)];},Game_BattlerBase['prototype'][_0x46d610(0x2d1)]=function(){const _0x3ce5c4=_0x46d610;if(this[_0x3ce5c4(0x32d)]===undefined){if(_0x3ce5c4(0x153)===_0x3ce5c4(0x276)){if(!_0x2b3810['isCTB']())return;if(!_0x4db8a8[_0x3ce5c4(0x328)]())return;if(this===_0x4fc4fe[_0x3ce5c4(0x1e1)]())return;if(this===_0x414620['_subject'])return;const _0x2693d1=this['getCurrentTurnOrderPositionCTB']();if(_0x2693d1<0x0)return;this[_0x3ce5c4(0x2d9)](_0x2693d1+_0x11e7f0);}else this['_ctbTurnOrderFaceIndex']=this['createTurnOrderCTBGraphicFaceIndex']();}return this[_0x3ce5c4(0x32d)];},Game_BattlerBase['prototype'][_0x46d610(0x2fe)]=function(){const _0x5a34a9=_0x46d610;return Window_CTB_TurnOrder[_0x5a34a9(0x311)][_0x5a34a9(0x1df)];},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x342)]=function(){const _0x1f05a0=_0x46d610;return this[_0x1f05a0(0x336)]===undefined&&(this['_ctbTurnOrderIconIndex']=this['createTurnOrderCTBGraphicIconIndex']()),this[_0x1f05a0(0x336)];},Game_BattlerBase['prototype'][_0x46d610(0x1c3)]=function(){return Window_CTB_TurnOrder['Settings']['EnemyBattlerIcon'];},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x309)]=function(_0x37c539){const _0xadd902=_0x46d610;this[_0xadd902(0x336)]=_0x37c539;},Game_BattlerBase['prototype'][_0x46d610(0x24a)]=function(_0x1cf69f,_0x5742dd){const _0x5ca3ce=_0x46d610;if(this[_0x5ca3ce(0x1c6)]())return Number['MAX_SAFE_INTEGER'];if(!this[_0x5ca3ce(0x195)]())return Number['MAX_SAFE_INTEGER'];if(_0x1cf69f===0x1&&!_0x5742dd){if('oYMfS'!==_0x5ca3ce(0x147)){const _0x564a26=_0x32075b[_0x5ca3ce(0x1be)]['JS'][_0x15afa7][_0x5ca3ce(0x17f)](this,this[_0x5ca3ce(0x213)](),_0x3be488);_0x52ddad[_0x5ca3ce(0x19d)](_0x564a26);}else{if(this===BattleManager[_0x5ca3ce(0x219)])return Number['MIN_SAFE_INTEGER']/0xa;if(this===BattleManager[_0x5ca3ce(0x1e1)]()){if(_0x5ca3ce(0x154)===_0x5ca3ce(0x154))return Number['MIN_SAFE_INTEGER']/0xa;else this['_tpbState']=_0x5ca3ce(0x247),this[_0x5ca3ce(0x215)]+=_0x1dd3d0[_0x5ca3ce(0x1be)][_0x5ca3ce(0x311)][_0x5ca3ce(0x324)][_0x5ca3ce(0x2a7)]||0x0;}if(BattleManager[_0x5ca3ce(0x16a)]&&BattleManager['_actionBattlers'][_0x5ca3ce(0x2d3)](this)){if(_0x5ca3ce(0x292)===_0x5ca3ce(0x292)){let _0x10750a=Number['MIN_SAFE_INTEGER']/0x1388;return _0x10750a+=BattleManager[_0x5ca3ce(0x16a)][_0x5ca3ce(0x221)](this)*0x5,_0x10750a;}else this['rotateCTBSprites'](),this['_subject'][_0x5ca3ce(0x16f)](_0x5ca3ce(0x2d0));}}}return _0x1cf69f-=this[_0x5ca3ce(0x1c5)](),_0x1cf69f/=this['tpbAcceleration'](),_0x1cf69f+=this[_0x5ca3ce(0x232)](),_0x1cf69f;},Game_BattlerBase[_0x46d610(0x341)][_0x46d610(0x232)]=function(){const _0x533bd7=_0x46d610;return this[_0x533bd7(0x15d)]===_0x533bd7(0x1c0)?_0x533bd7(0x30d)!==_0x533bd7(0x30d)?'face':(this[_0x533bd7(0x169)]()-this[_0x533bd7(0x273)])/this[_0x533bd7(0x24f)]():0x0;},VisuMZ[_0x46d610(0x1be)]['Game_Battler_initTpbChargeTime']=Game_Battler[_0x46d610(0x341)][_0x46d610(0x1f8)],Game_Battler[_0x46d610(0x341)][_0x46d610(0x1f8)]=function(_0x43fb87){const _0xb80626=_0x46d610;BattleManager['isCTB']()?this[_0xb80626(0x241)](_0x43fb87):VisuMZ['BattleSystemCTB'][_0xb80626(0x13a)][_0xb80626(0x17f)](this,_0x43fb87);},Game_Battler[_0x46d610(0x341)][_0x46d610(0x241)]=function(_0x9f37f7){const _0x235401=_0x46d610,_0x5ae5f9=VisuMZ[_0x235401(0x1be)][_0x235401(0x311)][_0x235401(0x324)];let _0x3a4c2b=this[_0x235401(0x33c)]()*eval(_0x5ae5f9['InitialGaugeJS']);const _0x46562c=this[_0x235401(0x291)]()[_0x235401(0x228)](this[_0x235401(0x150)]()),_0x5174ae=/<(?:CTB) (?:BATTLE START|START) (?:GAUGE|TIME|SPEED): ([\+\-]\d+)([%％])>/i,_0x538d0e=_0x46562c[_0x235401(0x2c2)](_0x17cedd=>_0x17cedd&&_0x17cedd[_0x235401(0x31c)][_0x235401(0x13b)](_0x5174ae)?Number(RegExp['$1'])*0.01:0x0);_0x3a4c2b=_0x538d0e['reduce']((_0x141919,_0x95f47a)=>_0x141919+_0x95f47a,_0x3a4c2b),this[_0x235401(0x15d)]='charging',this['_tpbChargeTime']=(_0x9f37f7?0x1:_0x3a4c2b)[_0x235401(0x198)](0x0,0x1),this[_0x235401(0x264)]()&&(this[_0x235401(0x215)]=0x0);},Game_Battler[_0x46d610(0x341)][_0x46d610(0x2ea)]=function(){const _0x16913f=_0x46d610;return this[_0x16913f(0x15d)]===_0x16913f(0x247);},Game_Battler[_0x46d610(0x341)][_0x46d610(0x1ca)]=function(){const _0x4c5064=_0x46d610;return this['_tpbState']===_0x4c5064(0x1c0)&&this['currentAction']()&&this['currentAction']()[_0x4c5064(0x33d)]()&&this[_0x4c5064(0x222)]()['item']()[_0x4c5064(0x28e)]<0x0;},Game_BattlerBase['prototype'][_0x46d610(0x308)]=function(){const _0x3830bc=_0x46d610;if(this[_0x3830bc(0x1ca)]()){if(_0x3830bc(0x17e)===_0x3830bc(0x1e5))_0x2e714f-=0x1;else return this['_tpbCastTime']/this[_0x3830bc(0x169)]();}else return'QOmxP'==='yvQeL'?_0x371396[_0x3830bc(0x2fc)][_0x3830bc(0x252)]:0x0;},Game_Battler['prototype'][_0x46d610(0x317)]=function(){const _0x17a06c=_0x46d610;return!this[_0x17a06c(0x1a5)]();},Game_Battler[_0x46d610(0x341)][_0x46d610(0x1d4)]=function(_0x3c9c92){const _0x16efcf=_0x46d610;this[_0x16efcf(0x2f4)]=_0x3c9c92;},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x23b)]=Game_Battler[_0x46d610(0x341)]['onRestrict'],Game_Battler[_0x46d610(0x341)][_0x46d610(0x15c)]=function(){const _0xa362f=_0x46d610;this[_0xa362f(0x236)]=BattleManager[_0xa362f(0x1d1)](),VisuMZ[_0xa362f(0x1be)]['Game_Battler_onRestrict']['call'](this),this['_onRestrictBypassCtbReset']=undefined;},VisuMZ['BattleSystemCTB'][_0x46d610(0x1aa)]=Game_Battler[_0x46d610(0x341)][_0x46d610(0x1fe)],Game_Battler[_0x46d610(0x341)]['clearTpbChargeTime']=function(){const _0x5ce251=_0x46d610;BattleManager[_0x5ce251(0x1d1)]()?this[_0x5ce251(0x1b7)]():VisuMZ[_0x5ce251(0x1be)][_0x5ce251(0x1aa)]['call'](this);},Game_Battler[_0x46d610(0x341)][_0x46d610(0x1b7)]=function(){const _0x923dd3=_0x46d610;if(this[_0x923dd3(0x236)])return;this['_tpbState']=_0x923dd3(0x247),this[_0x923dd3(0x215)]-=0x1,this[_0x923dd3(0x215)]+=this['_ctbAfterSpeed']||0x0;},VisuMZ['BattleSystemCTB']['Game_Battler_applyTpbPenalty']=Game_Battler[_0x46d610(0x341)][_0x46d610(0x196)],Game_Battler[_0x46d610(0x341)][_0x46d610(0x196)]=function(){const _0x1ea27d=_0x46d610;BattleManager[_0x1ea27d(0x1d1)]()?this['applyCTBPenalty']():VisuMZ[_0x1ea27d(0x1be)][_0x1ea27d(0x26b)][_0x1ea27d(0x17f)](this);},Game_Battler['prototype']['applyCTBPenalty']=function(){const _0x3d47cf=_0x46d610;this[_0x3d47cf(0x15d)]=_0x3d47cf(0x247),this[_0x3d47cf(0x215)]+=VisuMZ[_0x3d47cf(0x1be)]['Settings'][_0x3d47cf(0x324)][_0x3d47cf(0x2a7)]||0x0;},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x270)]=Game_Battler[_0x46d610(0x341)]['tpbSpeed'],Game_Battler['prototype'][_0x46d610(0x29a)]=function(){const _0x42445b=_0x46d610;return BattleManager[_0x42445b(0x1d1)]()?_0x42445b(0x1d2)!==_0x42445b(0x18d)?VisuMZ[_0x42445b(0x1be)]['Settings'][_0x42445b(0x324)][_0x42445b(0x1a7)][_0x42445b(0x17f)](this,this):(this['_ctbTurnOrderFaceName']===_0x45dbd0&&(this[_0x42445b(0x184)]=this[_0x42445b(0x207)]()),this[_0x42445b(0x184)]):VisuMZ['BattleSystemCTB'][_0x42445b(0x270)][_0x42445b(0x17f)](this);},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x1a4)]=Game_Battler[_0x46d610(0x341)][_0x46d610(0x26c)],Game_Battler[_0x46d610(0x341)][_0x46d610(0x26c)]=function(){const _0x2f7e2a=_0x46d610;if(BattleManager[_0x2f7e2a(0x1d1)]())return VisuMZ[_0x2f7e2a(0x1be)][_0x2f7e2a(0x311)][_0x2f7e2a(0x324)][_0x2f7e2a(0x2b0)]['call'](this,this);else{if(_0x2f7e2a(0x28d)!=='xEwTG'){const _0x3fe51c=new _0x37c600();_0x3fe51c[_0x2f7e2a(0x2f0)]['x']=this[_0x2f7e2a(0x2f0)]['x'],_0x3fe51c['anchor']['y']=this['anchor']['y'],this[_0x2f7e2a(0x2b9)]=_0x3fe51c,this['addChild'](this['_graphicSprite']),this[_0x2f7e2a(0x25e)]();}else return VisuMZ['BattleSystemCTB'][_0x2f7e2a(0x1a4)][_0x2f7e2a(0x17f)](this);}},VisuMZ['BattleSystemCTB'][_0x46d610(0x16b)]=Game_Battler[_0x46d610(0x341)][_0x46d610(0x33c)],Game_Battler[_0x46d610(0x341)]['tpbRelativeSpeed']=function(){const _0x37c367=_0x46d610;return BattleManager['isCTB']()?VisuMZ[_0x37c367(0x1be)][_0x37c367(0x311)]['Mechanics'][_0x37c367(0x249)][_0x37c367(0x17f)](this,this):VisuMZ[_0x37c367(0x1be)][_0x37c367(0x16b)][_0x37c367(0x17f)](this);},VisuMZ[_0x46d610(0x1be)]['Game_Battler_tpbAcceleration']=Game_Battler[_0x46d610(0x341)][_0x46d610(0x24f)],Game_Battler[_0x46d610(0x341)][_0x46d610(0x24f)]=function(){const _0xc7998e=_0x46d610;if(BattleManager[_0xc7998e(0x1d1)]()){if(_0xc7998e(0x234)===_0xc7998e(0x234)){let _0x3ff8fa=VisuMZ[_0xc7998e(0x1be)][_0xc7998e(0x311)]['Mechanics'][_0xc7998e(0x1e2)][_0xc7998e(0x17f)](this,this);const _0x330d00=0x0;return _0x3ff8fa+_0x330d00;}else return this[_0xc7998e(0x25e)]();}else return VisuMZ[_0xc7998e(0x1be)][_0xc7998e(0x21c)]['call'](this);},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x204)]=Game_Battler[_0x46d610(0x341)][_0x46d610(0x169)],Game_Battler[_0x46d610(0x341)][_0x46d610(0x169)]=function(){const _0x206ca3=_0x46d610;if(BattleManager[_0x206ca3(0x1d1)]())return VisuMZ[_0x206ca3(0x1be)]['Settings']['Mechanics'][_0x206ca3(0x23e)][_0x206ca3(0x17f)](this,this);else{if(_0x206ca3(0x2c1)===_0x206ca3(0x1c4))this[_0x206ca3(0x19d)](this[_0x206ca3(0x215)]+_0x371e3e);else return VisuMZ[_0x206ca3(0x1be)][_0x206ca3(0x204)]['call'](this);}},Game_Battler[_0x46d610(0x341)]['getCurrentTurnOrderPositionCTB']=function(){const _0x1803e8=_0x46d610,_0x112b1b=SceneManager[_0x1803e8(0x2fc)][_0x1803e8(0x252)];if(!_0x112b1b)return-0x1;const _0x18ba30=_0x112b1b['_turnOrderContainer'];if(!_0x18ba30)return-0x1;const _0x4dfe61=_0x18ba30[_0x1803e8(0x1dc)](_0x2ffbbd=>_0x2ffbbd[_0x1803e8(0x299)]()===this);return _0x18ba30[_0x1803e8(0x221)](_0x4dfe61);},Game_Battler[_0x46d610(0x341)][_0x46d610(0x1e4)]=function(_0x43e2e1){const _0x130a22=_0x46d610;if(!BattleManager[_0x130a22(0x1d1)]())return;if(!SceneManager[_0x130a22(0x328)]())return;if(this===BattleManager[_0x130a22(0x1e1)]())return;if(this===BattleManager[_0x130a22(0x219)])return;const _0x2a703c=this[_0x130a22(0x275)]();if(_0x2a703c<0x0)return;this[_0x130a22(0x2d9)](_0x2a703c+_0x43e2e1);},Game_Battler[_0x46d610(0x341)][_0x46d610(0x2d9)]=function(_0x4440dc){const _0x267102=_0x46d610;if(!BattleManager[_0x267102(0x1d1)]())return;if(!SceneManager[_0x267102(0x328)]())return;if(this===BattleManager[_0x267102(0x1e1)]())return;if(this===BattleManager[_0x267102(0x219)])return;_0x4440dc=Math[_0x267102(0x14c)](_0x4440dc,0x1),this['processTurnOrderChangeCTB'](_0x4440dc);},Game_Battler[_0x46d610(0x341)]['processTurnOrderChangeCTB']=function(_0x4b677b){const _0x3f719f=_0x46d610;if(!BattleManager[_0x3f719f(0x1d1)]())return;if(!SceneManager['isSceneBattle']())return;if(this===BattleManager[_0x3f719f(0x1e1)]())return;if(this===BattleManager[_0x3f719f(0x219)])return;const _0x70173c=SceneManager[_0x3f719f(0x2fc)]['_ctbTurnOrderWindow'];if(!_0x70173c)return;const _0x7c44c0=_0x70173c[_0x3f719f(0x235)];if(!_0x7c44c0)return;const _0x3a57a1=this[_0x3f719f(0x275)]();if(_0x3a57a1!==_0x4b677b){if(_0x3f719f(0x33f)===_0x3f719f(0x33f))this[_0x3f719f(0x20b)](_0x4b677b-_0x3a57a1);else return _0x1f91de[_0x3f719f(0x1be)][_0x3f719f(0x270)]['call'](this);}let _0x36a980=_0x4b677b,_0x17f24a=_0x4b677b;if(_0x3a57a1>_0x4b677b)_0x36a980-=0x1;else{if(_0x3f719f(0x162)!==_0x3f719f(0x174))_0x17f24a+=0x1;else{if(!this[_0x3f719f(0x1d1)]())return;const _0x71ddd1=_0x46053d[_0x3f719f(0x2fc)][_0x3f719f(0x252)];if(!_0x71ddd1)return;_0x71ddd1[_0x3f719f(0x24e)](_0x1a94a7);}}const _0x904e7f=_0x7c44c0[_0x36a980][_0x3f719f(0x2c8)](!![]),_0xa2e17=_0x7c44c0[_0x17f24a][_0x3f719f(0x2c8)](!![]),_0x5bea35=(_0x904e7f+_0xa2e17)/0x2;let _0x2253c7=_0x5bea35*this[_0x3f719f(0x24f)]();if(this[_0x3f719f(0x15d)]===_0x3f719f(0x247)){if(_0x3f719f(0x206)!==_0x3f719f(0x187))this[_0x3f719f(0x215)]=0x1-_0x2253c7;else return _0xd1128b(_0x53e87d['$1']);}else this[_0x3f719f(0x15d)]==='casting'&&(this[_0x3f719f(0x273)]=this[_0x3f719f(0x169)]()-_0x2253c7);BattleManager[_0x3f719f(0x16a)]=[],BattleManager[_0x3f719f(0x1f3)]();},Game_Battler[_0x46d610(0x341)][_0x46d610(0x20b)]=function(_0x1fab54){const _0x4b1a78=_0x46d610,_0x1e84d9=VisuMZ[_0x4b1a78(0x1be)][_0x4b1a78(0x311)][_0x4b1a78(0x26d)],_0xa1dae7=_0x1fab54>0x0?_0x4b1a78(0x149):_0x4b1a78(0x13e);if(_0x1e84d9[_0x4b1a78(0x23a)[_0x4b1a78(0x1cc)](_0xa1dae7)]){if(_0x4b1a78(0x2e5)===_0x4b1a78(0x1f5))_0x4de662[_0x4b1a78(0x1be)][_0x4b1a78(0x2c7)][_0x4b1a78(0x17f)](this,_0x364157);else{const _0x3c0667=_0x1e84d9[_0x4b1a78(0x23a)[_0x4b1a78(0x1cc)](_0xa1dae7)],_0x458690=_0x1e84d9[_0x4b1a78(0x140)[_0x4b1a78(0x1cc)](_0xa1dae7)],_0x5daa01=_0x1e84d9['%1Mute'[_0x4b1a78(0x1cc)](_0xa1dae7)];$gameTemp[_0x4b1a78(0x22c)]([this],_0x3c0667,_0x458690,_0x5daa01);}}if(this[_0x4b1a78(0x299)]()&&_0x1e84d9[_0x4b1a78(0x175)['format'](_0xa1dae7)]['length']>0x0){const _0x4e1d74=_0x1e84d9['%1PopupText'[_0x4b1a78(0x1cc)](_0xa1dae7)],_0x3a4e9e={'textColor':ColorManager[_0x4b1a78(0x1ad)](_0x1e84d9[_0x4b1a78(0x1e0)[_0x4b1a78(0x1cc)](_0xa1dae7)]),'flashColor':_0x1e84d9['%1FlashColor'[_0x4b1a78(0x1cc)](_0xa1dae7)],'flashDuration':_0x1e84d9[_0x4b1a78(0x1ab)[_0x4b1a78(0x1cc)](_0xa1dae7)]};this[_0x4b1a78(0x2ad)](_0x4e1d74,_0x3a4e9e);}},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x177)]=Game_Battler[_0x46d610(0x341)][_0x46d610(0x1e6)],Game_Battler[_0x46d610(0x341)][_0x46d610(0x1e6)]=function(){const _0x167b0b=_0x46d610;if(BattleManager[_0x167b0b(0x2aa)](this))return;VisuMZ['BattleSystemCTB'][_0x167b0b(0x177)][_0x167b0b(0x17f)](this);},BattleManager[_0x46d610(0x2aa)]=function(_0x867552){const _0x274690=_0x46d610;return BattleManager[_0x274690(0x223)]()[_0x274690(0x242)](_0x3b88f4=>_0x3b88f4!==_0x867552)[_0x274690(0x1f9)](_0x16c62f=>_0x16c62f['isAlive']()&&_0x16c62f[_0x274690(0x1a5)]()&&_0x16c62f[_0x274690(0x2f4)]>=0x1);},VisuMZ['BattleSystemCTB'][_0x46d610(0x15e)]=Game_Battler['prototype'][_0x46d610(0x26e)],Game_Battler[_0x46d610(0x341)][_0x46d610(0x26e)]=function(){const _0x23d441=_0x46d610;if(BattleManager[_0x23d441(0x1d1)]())this[_0x23d441(0x1da)]();else{if(_0x23d441(0x318)===_0x23d441(0x2be)){if(!this[_0x23d441(0x22f)])return;const _0x395385=this[_0x23d441(0x22f)][_0x23d441(0x2a2)];if(!_0x395385)return;_0x395385['sort'](this[_0x23d441(0x14e)][_0x23d441(0x24d)](this));}else VisuMZ[_0x23d441(0x1be)][_0x23d441(0x15e)][_0x23d441(0x17f)](this);}},Game_Battler[_0x46d610(0x341)]['updateTpbChargeTimeCTB']=function(){const _0x3df09f=_0x46d610;if(this[_0x3df09f(0x15d)]===_0x3df09f(0x247)){if(_0x3df09f(0x28c)===_0x3df09f(0x2d6)){const _0x5d9a47=this[_0x3df09f(0x260)]()[_0x3df09f(0x31c)];if(_0x5d9a47[_0x3df09f(0x13b)](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i))return _0x3df09f(0x2d8);else{if(_0x5d9a47[_0x3df09f(0x13b)](/<CTB TURN ORDER ICON:[ ](\d+)>/i))return _0x3df09f(0x1de);}return _0x4c18d5['Settings'][_0x3df09f(0x243)];}else this[_0x3df09f(0x215)]+=this[_0x3df09f(0x24f)](),this[_0x3df09f(0x215)]>=0x1&&this[_0x3df09f(0x315)]();}},VisuMZ[_0x46d610(0x1be)]['Game_Battler_updateTpbCastTime']=Game_Battler[_0x46d610(0x341)]['updateTpbCastTime'],Game_Battler[_0x46d610(0x341)]['updateTpbCastTime']=function(){const _0x209ab2=_0x46d610;BattleManager[_0x209ab2(0x1d1)]()?this[_0x209ab2(0x201)]():VisuMZ[_0x209ab2(0x1be)][_0x209ab2(0x32e)]['call'](this);},Game_Battler[_0x46d610(0x341)][_0x46d610(0x201)]=function(){const _0x59e5c0=_0x46d610;this[_0x59e5c0(0x15d)]==='casting'&&('NfuTV'===_0x59e5c0(0x2a9)?(_0x2b7b05[_0x59e5c0(0x1be)][_0x59e5c0(0x230)]['call'](this,_0x3f6f40),_0x3e2198['BattleSystemCTB'][_0x59e5c0(0x2da)](_0x3792a5)):(this[_0x59e5c0(0x273)]+=this['tpbAcceleration'](),this[_0x59e5c0(0x273)]>=this[_0x59e5c0(0x169)]()&&(this['_tpbState']=_0x59e5c0(0x1bf))));},Game_Actor['prototype'][_0x46d610(0x1af)]=function(){const _0x493785=_0x46d610,_0x31d003=this[_0x493785(0x1e1)]()[_0x493785(0x31c)];if(_0x31d003[_0x493785(0x13b)](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i))return'face';else{if(_0x31d003[_0x493785(0x13b)](/<CTB TURN ORDER ICON:[ ](\d+)>/i))return _0x493785(0x1de);}return Window_CTB_TurnOrder[_0x493785(0x311)][_0x493785(0x146)];},Game_Actor[_0x46d610(0x341)][_0x46d610(0x286)]=function(){const _0x4df796=_0x46d610,_0x3d31d4=this['actor']()['note'];if(_0x3d31d4[_0x4df796(0x13b)](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i))return String(RegExp['$1']);return this['faceName']();},Game_Actor['prototype'][_0x46d610(0x2d1)]=function(){const _0x65c57f=_0x46d610,_0x151c97=this[_0x65c57f(0x1e1)]()[_0x65c57f(0x31c)];if(_0x151c97[_0x65c57f(0x13b)](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i)){if(_0x65c57f(0x283)!==_0x65c57f(0x14d))return Number(RegExp['$2']);else this[_0x65c57f(0x274)]();}return this[_0x65c57f(0x2c0)]();},Game_Actor[_0x46d610(0x341)][_0x46d610(0x1c3)]=function(){const _0x3c1a40=_0x46d610,_0x2822cb=this[_0x3c1a40(0x1e1)]()[_0x3c1a40(0x31c)];if(_0x2822cb[_0x3c1a40(0x13b)](/<CTB TURN ORDER ICON:[ ](\d+)>/i))return Number(RegExp['$1']);return Window_CTB_TurnOrder[_0x3c1a40(0x311)][_0x3c1a40(0x331)];},Game_Enemy[_0x46d610(0x341)][_0x46d610(0x1af)]=function(){const _0x51c9ca=_0x46d610,_0x1d687d=this['enemy']()[_0x51c9ca(0x31c)];if(_0x1d687d[_0x51c9ca(0x13b)](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i)){if(_0x51c9ca(0x289)===_0x51c9ca(0x289))return _0x51c9ca(0x2d8);else{const _0x51782e=this[_0x51c9ca(0x260)]()['note'];if(_0x51782e['match'](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i))return _0x1409a3(_0x5f0b86['$2']);return _0x2acaf1['Settings']['EnemyBattlerFaceIndex'];}}else{if(_0x1d687d[_0x51c9ca(0x13b)](/<CTB TURN ORDER ICON:[ ](\d+)>/i)){if(_0x51c9ca(0x1bd)==='ikULY')return'icon';else this['_graphicSv']=_0x3124bb[_0x51c9ca(0x245)](),_0x4437a1=_0x22e09b[_0x51c9ca(0x29f)](this['_graphicSv']),_0x47c4b3[_0x51c9ca(0x2eb)](this[_0x51c9ca(0x1d5)][_0x51c9ca(0x24d)](this,_0xc1cb83));}}return Window_CTB_TurnOrder[_0x51c9ca(0x311)]['EnemyBattlerType'];},Game_Enemy[_0x46d610(0x341)]['createTurnOrderCTBGraphicFaceName']=function(){const _0xc1774a=_0x46d610,_0x3c44e1=this[_0xc1774a(0x260)]()[_0xc1774a(0x31c)];if(_0x3c44e1[_0xc1774a(0x13b)](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i)){if('frevn'===_0xc1774a(0x248))this[_0xc1774a(0x281)]+=_0x26c773?_0x57ad10:0x0,this[_0xc1774a(0x199)]+=_0x33d569?0x0:_0xca689e;else return String(RegExp['$1']);}return Window_CTB_TurnOrder['Settings'][_0xc1774a(0x329)];},Game_Enemy[_0x46d610(0x341)][_0x46d610(0x2fe)]=function(){const _0x5575ea=_0x46d610,_0x2450ab=this[_0x5575ea(0x260)]()['note'];if(_0x2450ab[_0x5575ea(0x13b)](/<CTB TURN ORDER FACE:[ ](.*),[ ](\d+)>/i))return Number(RegExp['$2']);return Window_CTB_TurnOrder['Settings'][_0x5575ea(0x1df)];},Game_Enemy[_0x46d610(0x341)][_0x46d610(0x1c3)]=function(){const _0x123c9f=_0x46d610,_0x1e8199=this['enemy']()[_0x123c9f(0x31c)];if(_0x1e8199[_0x123c9f(0x13b)](/<CTB TURN ORDER ICON:[ ](\d+)>/i)){if(_0x123c9f(0x269)==='Qqews'){const _0x16588a=this[_0x123c9f(0x299)]();if(!_0x16588a)return;if(this[_0x123c9f(0x182)]===_0x16588a['isAlive']()&&this[_0x123c9f(0x2db)]===_0x16588a['isAppeared']())return;this[_0x123c9f(0x182)]=_0x16588a[_0x123c9f(0x2bc)](),this['_isAppeared']=_0x16588a['isAppeared']();let _0x18e416=this['_isAlive']&&this[_0x123c9f(0x2db)]?0xff:0x0;this[_0x123c9f(0x192)](_0x18e416);}else return Number(RegExp['$1']);}return Window_CTB_TurnOrder['Settings'][_0x123c9f(0x197)];},VisuMZ[_0x46d610(0x1be)][_0x46d610(0x1e9)]=Scene_Battle[_0x46d610(0x341)][_0x46d610(0x224)],Scene_Battle['prototype'][_0x46d610(0x224)]=function(){const _0x253b28=_0x46d610;VisuMZ[_0x253b28(0x1be)][_0x253b28(0x1e9)][_0x253b28(0x17f)](this),this[_0x253b28(0x1d9)]();},Scene_Battle[_0x46d610(0x341)][_0x46d610(0x1d9)]=function(){const _0x2b5b2a=_0x46d610;if(!BattleManager[_0x2b5b2a(0x1d1)]())return;this[_0x2b5b2a(0x252)]=new Window_CTB_TurnOrder();const _0x1bc3ce=this[_0x2b5b2a(0x2d5)](this[_0x2b5b2a(0x280)]);this['addChildAt'](this[_0x2b5b2a(0x252)],_0x1bc3ce),this[_0x2b5b2a(0x158)](),BattleManager[_0x2b5b2a(0x1f3)](!![]);},Scene_Battle['prototype'][_0x46d610(0x158)]=function(){const _0x32418f=_0x46d610,_0x182a2f=Window_CTB_TurnOrder['Settings'];if(_0x182a2f['DisplayPosition']!==_0x32418f(0x1c9))return;if(!_0x182a2f['RepositionLogWindow'])return;if(!this[_0x32418f(0x1a1)])return;const _0x1c9077=this[_0x32418f(0x252)]['y']-Math[_0x32418f(0x267)]((Graphics[_0x32418f(0x2b7)]-Graphics[_0x32418f(0x259)])/0x2),_0x9365c6=_0x1c9077+this[_0x32418f(0x252)]['height'];this['_logWindow']['y']=_0x9365c6+_0x182a2f[_0x32418f(0x24b)];};function Sprite_CTB_TurnOrder_Battler(){const _0x820be7=_0x46d610;this[_0x820be7(0x186)](...arguments);}Sprite_CTB_TurnOrder_Battler['prototype']=Object[_0x46d610(0x316)](Sprite_Clickable[_0x46d610(0x341)]),Sprite_CTB_TurnOrder_Battler['prototype'][_0x46d610(0x253)]=Sprite_CTB_TurnOrder_Battler,Sprite_CTB_TurnOrder_Battler['prototype']['initialize']=function(_0x8a5f3f,_0x23781c,_0x3cf501){const _0x2394a8=_0x46d610;this[_0x2394a8(0x30f)](_0x8a5f3f,_0x23781c,_0x3cf501),Sprite_Clickable['prototype'][_0x2394a8(0x186)][_0x2394a8(0x17f)](this),this[_0x2394a8(0x239)]();},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x30f)]=function(_0x4a0f82,_0x7643e1,_0x32d667){const _0x37f2d6=_0x46d610;this[_0x37f2d6(0x22b)]=_0x4a0f82,this[_0x37f2d6(0x2dc)]=_0x7643e1,this[_0x37f2d6(0x2a6)]=_0x32d667;const _0x1ee6b6=Window_CTB_TurnOrder['Settings'],_0x7a2d82=this['isHorz'](),_0x452d29=this['defaultPosition']();this[_0x37f2d6(0x183)]=0x0,this[_0x37f2d6(0x281)]=_0x7a2d82?_0x1ee6b6[_0x37f2d6(0x2b6)]*_0x452d29:0x0,this[_0x37f2d6(0x199)]=_0x7a2d82?0x0:_0x1ee6b6[_0x37f2d6(0x2b6)]*_0x452d29,this[_0x37f2d6(0x164)]=0x0,this[_0x37f2d6(0x1ec)]=0xff,this[_0x37f2d6(0x182)]=!![],this[_0x37f2d6(0x2db)]=!![];},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)]['createChildren']=function(){const _0x43d1c7=_0x46d610;this[_0x43d1c7(0x20f)](),this['createBackgroundSprite'](),this['createGraphicSprite'](),this[_0x43d1c7(0x32c)](),this[_0x43d1c7(0x157)]();},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x20f)]=function(){const _0x4163cf=_0x46d610;this['x']=this[_0x4163cf(0x281)],this['y']=this[_0x4163cf(0x199)];},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x1cd)]=function(){const _0x3977bb=_0x46d610,_0x138c88=Window_CTB_TurnOrder[_0x3977bb(0x311)],_0xe46ca6=[_0x3977bb(0x1c9),_0x3977bb(0x19e)][_0x3977bb(0x2d3)](_0x138c88[_0x3977bb(0x33b)]);return _0xe46ca6;},Sprite_CTB_TurnOrder_Battler['prototype'][_0x46d610(0x2e7)]=function(){const _0x2cd249=_0x46d610,_0x246550=Window_CTB_TurnOrder[_0x2cd249(0x311)];return this[_0x2cd249(0x1cd)]()?_0x246550[_0x2cd249(0x2b6)]:_0x246550[_0x2cd249(0x1d7)];},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)]['bitmapHeight']=function(){const _0x3b50c4=_0x46d610,_0x1996ab=Window_CTB_TurnOrder[_0x3b50c4(0x311)];return this[_0x3b50c4(0x1cd)]()?_0x1996ab[_0x3b50c4(0x1d7)]:_0x1996ab[_0x3b50c4(0x2b6)];},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x21e)]=function(){const _0x5a1de0=_0x46d610;this[_0x5a1de0(0x14a)]=new Bitmap(0x48,0x24);const _0x254cab=this[_0x5a1de0(0x299)]()?this[_0x5a1de0(0x299)]()[_0x5a1de0(0x15b)]():'%1\x20%2\x20%3'[_0x5a1de0(0x1cc)](this['_unit'],this[_0x5a1de0(0x2dc)],this['_dupe']);this[_0x5a1de0(0x14a)][_0x5a1de0(0x2b3)](_0x254cab,0x0,0x0,0x48,0x24,'center');},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x203)]=function(){const _0x180b73=_0x46d610;if(!Window_CTB_TurnOrder[_0x180b73(0x311)][_0x180b73(0x20c)])return;const _0x296a74=Window_CTB_TurnOrder[_0x180b73(0x311)],_0x16ba47=this[_0x180b73(0x22b)]===$gameParty?_0x180b73(0x2c9):_0x180b73(0x25b),_0x5ab12b=_0x180b73(0x305)[_0x180b73(0x1cc)](_0x16ba47),_0x57e80d=new Sprite();_0x57e80d[_0x180b73(0x2f0)]['x']=this[_0x180b73(0x2f0)]['x'],_0x57e80d['anchor']['y']=this[_0x180b73(0x2f0)]['y'];if(_0x296a74[_0x5ab12b])_0x57e80d[_0x180b73(0x14a)]=ImageManager['loadSystem'](_0x296a74[_0x5ab12b]);else{if(_0x180b73(0x2f5)!=='GFjMb'){const _0x175272=this[_0x180b73(0x2e7)](),_0x1d6d16=this[_0x180b73(0x2c5)]();_0x57e80d[_0x180b73(0x14a)]=new Bitmap(_0x175272,_0x1d6d16);const _0x360ca4=ColorManager[_0x180b73(0x1ad)](_0x296a74['%1BgColor1'[_0x180b73(0x1cc)](_0x16ba47)]),_0x394900=ColorManager[_0x180b73(0x1ad)](_0x296a74[_0x180b73(0x17b)['format'](_0x16ba47)]);_0x57e80d[_0x180b73(0x14a)][_0x180b73(0x16e)](0x0,0x0,_0x175272,_0x1d6d16,_0x360ca4,_0x394900,!![]);}else this[_0x180b73(0x155)]();}this[_0x180b73(0x2ee)]=_0x57e80d,this[_0x180b73(0x1bb)](this[_0x180b73(0x2ee)]),this[_0x180b73(0x205)]=this[_0x180b73(0x2ee)][_0x180b73(0x205)],this['height']=this[_0x180b73(0x2ee)][_0x180b73(0x2b7)];},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x28b)]=function(){const _0x7de578=_0x46d610,_0x1a98e3=new Sprite();_0x1a98e3[_0x7de578(0x2f0)]['x']=this['anchor']['x'],_0x1a98e3['anchor']['y']=this[_0x7de578(0x2f0)]['y'],this[_0x7de578(0x2b9)]=_0x1a98e3,this[_0x7de578(0x1bb)](this[_0x7de578(0x2b9)]),this[_0x7de578(0x25e)]();},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)]['createBorderSprite']=function(){const _0x4f7d83=_0x46d610;if(!Window_CTB_TurnOrder[_0x4f7d83(0x311)]['ShowMarkerBorder'])return;const _0x29b9a8=Window_CTB_TurnOrder['Settings'],_0x4a7982=this[_0x4f7d83(0x22b)]===$gameParty?_0x4f7d83(0x2c9):_0x4f7d83(0x25b),_0x3c3b0f='%1SystemBorder'[_0x4f7d83(0x1cc)](_0x4a7982),_0x28d2ce=new Sprite();_0x28d2ce[_0x4f7d83(0x2f0)]['x']=this[_0x4f7d83(0x2f0)]['x'],_0x28d2ce[_0x4f7d83(0x2f0)]['y']=this[_0x4f7d83(0x2f0)]['y'];if(_0x29b9a8[_0x3c3b0f])_0x28d2ce[_0x4f7d83(0x14a)]=ImageManager[_0x4f7d83(0x1f6)](_0x29b9a8[_0x3c3b0f]);else{let _0x4d54e0=this[_0x4f7d83(0x2e7)](),_0x4768d5=this['bitmapHeight'](),_0x574430=_0x29b9a8[_0x4f7d83(0x19f)];_0x28d2ce[_0x4f7d83(0x14a)]=new Bitmap(_0x4d54e0,_0x4768d5);const _0x29e7f8=_0x4f7d83(0x2b5),_0x53f93c=ColorManager[_0x4f7d83(0x1ad)](_0x29b9a8[_0x4f7d83(0x326)[_0x4f7d83(0x1cc)](_0x4a7982)]);_0x28d2ce['bitmap']['fillRect'](0x0,0x0,_0x4d54e0,_0x4768d5,_0x29e7f8),_0x4d54e0-=0x2,_0x4768d5-=0x2,_0x28d2ce[_0x4f7d83(0x14a)]['fillRect'](0x1,0x1,_0x4d54e0,_0x4768d5,_0x53f93c),_0x4d54e0-=_0x574430*0x2,_0x4768d5-=_0x574430*0x2,_0x28d2ce[_0x4f7d83(0x14a)][_0x4f7d83(0x1fd)](0x1+_0x574430,0x1+_0x574430,_0x4d54e0,_0x4768d5,_0x29e7f8),_0x4d54e0-=0x2,_0x4768d5-=0x2,_0x574430+=0x1,_0x28d2ce[_0x4f7d83(0x14a)]['clearRect'](0x1+_0x574430,0x1+_0x574430,_0x4d54e0,_0x4768d5);}this['_backgroundSprite']=_0x28d2ce,this[_0x4f7d83(0x1bb)](this[_0x4f7d83(0x2ee)]);},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)]['createLetterSprite']=function(){const _0x40587a=_0x46d610,_0x47ba4a=Window_CTB_TurnOrder[_0x40587a(0x311)];if(!_0x47ba4a['EnemyBattlerDrawLetter'])return;if(this[_0x40587a(0x22b)]===$gameParty)return;const _0x1b1198=this[_0x40587a(0x2e7)](),_0x45add1=this[_0x40587a(0x2c5)](),_0x4d3ee2=new Sprite();_0x4d3ee2[_0x40587a(0x2f0)]['x']=this[_0x40587a(0x2f0)]['x'],_0x4d3ee2['anchor']['y']=this[_0x40587a(0x2f0)]['y'],_0x4d3ee2[_0x40587a(0x14a)]=new Bitmap(_0x1b1198,_0x45add1),this[_0x40587a(0x268)]=_0x4d3ee2,this[_0x40587a(0x1bb)](this[_0x40587a(0x268)]);},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x299)]=function(){const _0x212338=_0x46d610;return this[_0x212338(0x22b)]?this[_0x212338(0x22b)]['members']()[this['_index']]:null;},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x2c8)]=function(_0x51b95e){const _0x34ca3f=_0x46d610,_0x47deee=this[_0x34ca3f(0x299)]();if(!_0x47deee)return Number['MAX_SAFE_INTEGER'];const _0x3132e5=0x1*(this[_0x34ca3f(0x2a6)]+0x1);return _0x47deee[_0x34ca3f(0x24a)](_0x3132e5,_0x51b95e);},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x2ec)]=function(){const _0xf94a54=_0x46d610;Sprite_Clickable['prototype'][_0xf94a54(0x2ec)]['call'](this),this[_0xf94a54(0x27b)](),this[_0xf94a54(0x272)](),this[_0xf94a54(0x1a2)](),this['updateOpacity'](),this[_0xf94a54(0x17c)](),this[_0xf94a54(0x15a)](),this['updateLetter'](),this['updateSelectionEffect']();},Sprite_CTB_TurnOrder_Battler['prototype']['checkPosition']=function(){const _0x5dae0c=_0x46d610,_0x127cb1=this[_0x5dae0c(0x1db)]();if(this[_0x5dae0c(0x193)]===_0x127cb1)return;this['_position']=_0x127cb1;const _0x2bcb7f=Window_CTB_TurnOrder[_0x5dae0c(0x311)],_0x52e209=this['isHorz'](),_0x46630e=_0x2bcb7f[_0x5dae0c(0x27f)],_0x52bd71=_0x2bcb7f[_0x5dae0c(0x1b8)],_0x514c9b=SceneManager[_0x5dae0c(0x2fc)][_0x5dae0c(0x252)];if(!_0x514c9b)return;this[_0x5dae0c(0x183)]=_0x2bcb7f[_0x5dae0c(0x319)],this['_positionTargetX']=_0x52e209?_0x2bcb7f[_0x5dae0c(0x2b6)]*_0x127cb1:0x0,this[_0x5dae0c(0x199)]=_0x52e209?0x0:_0x2bcb7f['SpriteThin']*_0x127cb1;_0x127cb1>0x0&&(this[_0x5dae0c(0x281)]+=_0x52e209?_0x52bd71:0x0,this['_positionTargetY']+=_0x52e209?0x0:_0x52bd71);if(_0x46630e){if(_0x5dae0c(0x2ae)===_0x5dae0c(0x2e2)){const _0x3b1df4=this[_0x5dae0c(0x2e7)](),_0x853a42=this[_0x5dae0c(0x2c5)]();_0x280367[_0x5dae0c(0x14a)]=new _0x42299d(_0x3b1df4,_0x853a42);const _0x2180f4=_0x2aa03d[_0x5dae0c(0x1ad)](_0x3b2df4['%1BgColor1'['format'](_0x58a3a5)]),_0x4878cd=_0x4579ca[_0x5dae0c(0x1ad)](_0x5ab1f1['%1BgColor2'[_0x5dae0c(0x1cc)](_0x399e13)]);_0x488980[_0x5dae0c(0x14a)][_0x5dae0c(0x16e)](0x0,0x0,_0x3b1df4,_0x853a42,_0x2180f4,_0x4878cd,!![]);}else this[_0x5dae0c(0x281)]=_0x52e209?_0x514c9b['width']-this[_0x5dae0c(0x281)]-_0x2bcb7f[_0x5dae0c(0x2b6)]:0x0;}else this[_0x5dae0c(0x199)]=_0x52e209?0x0:_0x514c9b[_0x5dae0c(0x2b7)]-this[_0x5dae0c(0x199)]-_0x2bcb7f['SpriteThin'];},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x272)]=function(){const _0x126854=_0x46d610;if(this[_0x126854(0x164)]>0x0)return;if(this[_0x126854(0x183)]>0x0){const _0x3eabe7=this[_0x126854(0x183)];this['x']=(this['x']*(_0x3eabe7-0x1)+this[_0x126854(0x281)])/_0x3eabe7,this['y']=(this['y']*(_0x3eabe7-0x1)+this[_0x126854(0x199)])/_0x3eabe7,this['_positionDuration']--;}this['_positionDuration']<=0x0&&this[_0x126854(0x182)]&&(this['x']=this[_0x126854(0x281)],this['y']=this[_0x126854(0x199)],this['opacity']<=0x0&&!this[_0x126854(0x2e8)]&&this[_0x126854(0x192)](0xff));},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)]['defaultPosition']=function(){const _0x5ab58f=_0x46d610;return Window_CTB_TurnOrder[_0x5ab58f(0x311)][_0x5ab58f(0x333)]*0x14;},Sprite_CTB_TurnOrder_Battler['prototype'][_0x46d610(0x250)]=function(){const _0xf63cde=_0x46d610;return SceneManager['_scene'][_0xf63cde(0x252)];},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x1db)]=function(){const _0x450658=_0x46d610;if(!this['containerWindow']())return this['defaultPosition']();const _0x1a22f3=this['containerWindow']()[_0x450658(0x235)];return _0x1a22f3[_0x450658(0x221)](this);},Sprite_CTB_TurnOrder_Battler['prototype']['rotateDupeNumber']=function(){const _0x14f6c4=_0x46d610,_0xce51bf=Window_CTB_TurnOrder[_0x14f6c4(0x311)],_0xb03b41=this['isHorz'](),_0x4ff9e2=_0xb03b41?_0xce51bf[_0x14f6c4(0x333)]:_0xce51bf[_0x14f6c4(0x2a3)];this['_dupe']-=0x1;if(this['_dupe']<0x0){if(_0x14f6c4(0x304)!==_0x14f6c4(0x1dd))this[_0x14f6c4(0x2a6)]=_0x4ff9e2-0x1,this[_0x14f6c4(0x192)](0x0);else{const _0x502f83=this[_0x14f6c4(0x299)]();if(!_0x502f83)return _0x3e312a[_0x14f6c4(0x1a9)];const _0xa53fbb=0x1*(this[_0x14f6c4(0x2a6)]+0x1);return _0x502f83['ctbTicksToGoal'](_0xa53fbb,_0x104e7c);}}},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x192)]=function(_0x534112){const _0x4fa64a=_0x46d610,_0x55564f=Window_CTB_TurnOrder[_0x4fa64a(0x311)];this[_0x4fa64a(0x164)]=_0x55564f[_0x4fa64a(0x319)],this['_fadeTarget']=_0x534112;},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x1a2)]=function(){const _0x39fdc2=_0x46d610,_0x416d8d=this[_0x39fdc2(0x299)]();if(!_0x416d8d)return;if(this[_0x39fdc2(0x182)]===_0x416d8d[_0x39fdc2(0x2bc)]()&&this[_0x39fdc2(0x2db)]===_0x416d8d['isAppeared']())return;this[_0x39fdc2(0x182)]=_0x416d8d[_0x39fdc2(0x2bc)](),this[_0x39fdc2(0x2db)]=_0x416d8d[_0x39fdc2(0x195)]();let _0x549f9e=this[_0x39fdc2(0x182)]&&this[_0x39fdc2(0x2db)]?0xff:0x0;this[_0x39fdc2(0x192)](_0x549f9e);},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x332)]=function(){const _0x52d73c=_0x46d610;if(this[_0x52d73c(0x164)]>0x0){if('fszPN'!==_0x52d73c(0x210)){const _0x47b328=this[_0x52d73c(0x164)];this[_0x52d73c(0x294)]=(this[_0x52d73c(0x294)]*(_0x47b328-0x1)+this[_0x52d73c(0x1ec)])/_0x47b328,this['_fadeDuration']--,this[_0x52d73c(0x164)]<=0x0&&(this[_0x52d73c(0x27b)](),this[_0x52d73c(0x183)]=0x0,this[_0x52d73c(0x272)](),this[_0x52d73c(0x294)]=this[_0x52d73c(0x1ec)]);}else this[_0x52d73c(0x18e)]=_0x36bf75[_0x52d73c(0x2b4)](),_0x2fc357=_0x146e82['loadSvEnemy'](this[_0x52d73c(0x18e)]),_0x5e5700[_0x52d73c(0x2eb)](this[_0x52d73c(0x2ac)][_0x52d73c(0x24d)](this,_0x55199e));}if(this[_0x52d73c(0x2e8)])return;BattleManager[_0x52d73c(0x2ab)]===_0x52d73c(0x29e)&&(this['_isBattleOver']=!![],this[_0x52d73c(0x192)](0x0));},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)]['updateGraphic']=function(){const _0x14cb5d=_0x46d610,_0x16a4f3=this['battler']();if(!_0x16a4f3)return;const _0x45892a=Window_CTB_TurnOrder[_0x14cb5d(0x311)],_0x18a925=this[_0x14cb5d(0x22b)]===$gameParty?_0x14cb5d(0x2c9):_0x14cb5d(0x25b);let _0x4afab7=_0x16a4f3['TurnOrderCTBGraphicType']();if(_0x16a4f3['isActor']()&&_0x4afab7==='enemy')_0x4afab7=_0x14cb5d(0x2d8);else _0x16a4f3[_0x14cb5d(0x1f0)]()&&_0x4afab7===_0x14cb5d(0x2a5)&&(_0x4afab7=_0x14cb5d(0x260));if(this[_0x14cb5d(0x2bf)]!==_0x4afab7)return this[_0x14cb5d(0x25e)]();switch(this[_0x14cb5d(0x2bf)]){case'face':if(this['_graphicFaceName']!==_0x16a4f3[_0x14cb5d(0x286)]())return this[_0x14cb5d(0x25e)]();if(this[_0x14cb5d(0x1fb)]!==_0x16a4f3[_0x14cb5d(0x2d1)]())return this[_0x14cb5d(0x25e)]();break;case _0x14cb5d(0x1de):if(this[_0x14cb5d(0x1c7)]!==_0x16a4f3['TurnOrderCTBGraphicIconIndex']())return this[_0x14cb5d(0x25e)]();break;case _0x14cb5d(0x260):if(_0x16a4f3[_0x14cb5d(0x2fd)]()){if(_0x14cb5d(0x1d3)==='fLkQC'){if(this[_0x14cb5d(0x166)]!==_0x16a4f3['svBattlerName']())return this['processUpdateGraphic']();}else _0x511697[_0x14cb5d(0x27a)](_0x14cb5d(0x160),this[_0x14cb5d(0x15f)]);}else{if(this[_0x14cb5d(0x18e)]!==_0x16a4f3[_0x14cb5d(0x2b4)]())return this[_0x14cb5d(0x25e)]();}break;case'svactor':if(_0x16a4f3['isActor']()){if(this[_0x14cb5d(0x166)]!==_0x16a4f3[_0x14cb5d(0x2b4)]())return this[_0x14cb5d(0x25e)]();}else{if(this[_0x14cb5d(0x18e)]!==_0x16a4f3['battlerName']())return this[_0x14cb5d(0x25e)]();}break;}},Sprite_CTB_TurnOrder_Battler['prototype'][_0x46d610(0x25e)]=function(){const _0x3b1579=_0x46d610,_0x195714=this[_0x3b1579(0x299)]();if(!_0x195714)return;this['_graphicType']=_0x195714[_0x3b1579(0x214)]();if(_0x195714[_0x3b1579(0x343)]()&&this[_0x3b1579(0x2bf)]===_0x3b1579(0x260))this[_0x3b1579(0x2bf)]=_0x3b1579(0x2d8);else _0x195714['isEnemy']()&&this['_graphicType']===_0x3b1579(0x2a5)&&(this['_graphicType']=_0x3b1579(0x260));let _0x2791d8;switch(this[_0x3b1579(0x2bf)]){case _0x3b1579(0x2d8):this[_0x3b1579(0x271)]=_0x195714[_0x3b1579(0x286)](),this[_0x3b1579(0x1fb)]=_0x195714[_0x3b1579(0x2d1)](),_0x2791d8=ImageManager[_0x3b1579(0x181)](this[_0x3b1579(0x271)]),_0x2791d8[_0x3b1579(0x2eb)](this['changeFaceGraphicBitmap'][_0x3b1579(0x24d)](this,_0x2791d8));break;case _0x3b1579(0x1de):this[_0x3b1579(0x1c7)]=_0x195714[_0x3b1579(0x1c3)](),_0x2791d8=ImageManager['loadSystem'](_0x3b1579(0x327)),_0x2791d8[_0x3b1579(0x2eb)](this[_0x3b1579(0x2e6)]['bind'](this,_0x2791d8));break;case _0x3b1579(0x260):if(_0x195714[_0x3b1579(0x2fd)]()){if(_0x3b1579(0x31e)==='oAXgo')this[_0x3b1579(0x166)]=_0x195714['svBattlerName'](),_0x2791d8=ImageManager['loadSvActor'](this['_graphicSv']),_0x2791d8[_0x3b1579(0x2eb)](this[_0x3b1579(0x1d5)][_0x3b1579(0x24d)](this,_0x2791d8));else{const _0xacd7c4=_0x35dbcb[_0x3b1579(0x31c)];if(_0xacd7c4[_0x3b1579(0x13b)](_0x127269['BattleSystemCTB'][_0x3b1579(0x1b0)][_0x26625a])){const _0x170aa0=_0x1740ae(_0x5305b6['$1']),_0x1bbfd5=_0x3b1579(0x20d)[_0x3b1579(0x1cc)](_0x170aa0,_0x48e7cb),_0x3ecd0d=_0x10d08a[_0x3b1579(0x1be)][_0x3b1579(0x31a)](_0x2493a2,_0x7c8492);_0x1c1441[_0x3b1579(0x1be)]['JS'][_0x3ecd0d]=new _0x31def6(_0x1bbfd5);}}}else{if($gameSystem['isSideView']()){if(_0x3b1579(0x233)!==_0x3b1579(0x290))this['_graphicEnemy']=_0x195714[_0x3b1579(0x2b4)](),_0x2791d8=ImageManager[_0x3b1579(0x1fa)](this[_0x3b1579(0x18e)]),_0x2791d8[_0x3b1579(0x2eb)](this['changeEnemyGraphicBitmap']['bind'](this,_0x2791d8));else{this[_0x3b1579(0x22b)]=_0x125c43,this['_index']=_0x6f3bd6,this['_dupe']=_0x4d721c;const _0x1ec09c=_0x52dc5f[_0x3b1579(0x311)],_0x9a2048=this[_0x3b1579(0x1cd)](),_0x5e64de=this[_0x3b1579(0x2b2)]();this[_0x3b1579(0x183)]=0x0,this[_0x3b1579(0x281)]=_0x9a2048?_0x1ec09c[_0x3b1579(0x2b6)]*_0x5e64de:0x0,this[_0x3b1579(0x199)]=_0x9a2048?0x0:_0x1ec09c[_0x3b1579(0x2b6)]*_0x5e64de,this[_0x3b1579(0x164)]=0x0,this[_0x3b1579(0x1ec)]=0xff,this[_0x3b1579(0x182)]=!![],this['_isAppeared']=!![];}}else this[_0x3b1579(0x18e)]=_0x195714[_0x3b1579(0x2b4)](),_0x2791d8=ImageManager[_0x3b1579(0x31f)](this[_0x3b1579(0x18e)]),_0x2791d8[_0x3b1579(0x2eb)](this[_0x3b1579(0x2ac)][_0x3b1579(0x24d)](this,_0x2791d8));}break;case _0x3b1579(0x2a5):this['_graphicSv']=_0x195714['battlerName'](),_0x2791d8=ImageManager[_0x3b1579(0x29f)](this[_0x3b1579(0x166)]),_0x2791d8[_0x3b1579(0x2eb)](this[_0x3b1579(0x1d5)][_0x3b1579(0x24d)](this,_0x2791d8));break;}},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x297)]=function(_0x1e9c72){const _0x23e15f=_0x46d610,_0x26736f=this[_0x23e15f(0x1fb)],_0x2b6fda=this[_0x23e15f(0x2e7)](),_0x20cf7a=this['bitmapHeight'](),_0x92faee=Math['max'](_0x2b6fda,_0x20cf7a);this[_0x23e15f(0x2b9)][_0x23e15f(0x14a)]=new Bitmap(_0x2b6fda,_0x20cf7a);const _0x251184=this['_graphicSprite'][_0x23e15f(0x14a)],_0x4bfe34=ImageManager['faceWidth'],_0x1cf521=ImageManager['faceHeight'],_0x8b47df=_0x92faee/Math['max'](_0x4bfe34,_0x1cf521),_0xc44568=ImageManager[_0x23e15f(0x13f)],_0x430764=ImageManager[_0x23e15f(0x16d)],_0xb23e2=_0x26736f%0x4*_0x4bfe34+(_0x4bfe34-_0xc44568)/0x2,_0x221d3d=Math[_0x23e15f(0x189)](_0x26736f/0x4)*_0x1cf521+(_0x1cf521-_0x430764)/0x2,_0x378730=(_0x2b6fda-_0x4bfe34*_0x8b47df)/0x2,_0x5b19a2=(_0x20cf7a-_0x1cf521*_0x8b47df)/0x2;_0x251184[_0x23e15f(0x28a)](_0x1e9c72,_0xb23e2,_0x221d3d,_0xc44568,_0x430764,_0x378730,_0x5b19a2,_0x92faee,_0x92faee);},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x2e6)]=function(_0x4756c6){const _0xffb7d7=_0x46d610,_0x664097=this[_0xffb7d7(0x1c7)],_0x4e8598=this[_0xffb7d7(0x2e7)](),_0x531230=this[_0xffb7d7(0x2c5)]();this[_0xffb7d7(0x2b9)][_0xffb7d7(0x14a)]=new Bitmap(_0x4e8598,_0x531230);const _0x4436dd=this[_0xffb7d7(0x2b9)][_0xffb7d7(0x14a)],_0xced4ad=ImageManager[_0xffb7d7(0x257)],_0x430cc2=ImageManager[_0xffb7d7(0x2d7)],_0x40d9cf=Math['min'](_0xced4ad,_0x430cc2,_0x4e8598,_0x531230),_0x18f8f3=_0x664097%0x10*_0xced4ad,_0x4adaa2=Math[_0xffb7d7(0x189)](_0x664097/0x10)*_0x430cc2,_0x575715=Math[_0xffb7d7(0x189)](Math['max'](_0x4e8598-_0x40d9cf,0x0)/0x2),_0x3cf1ff=Math[_0xffb7d7(0x189)](Math[_0xffb7d7(0x14c)](_0x531230-_0x40d9cf,0x0)/0x2);_0x4436dd[_0xffb7d7(0x28a)](_0x4756c6,_0x18f8f3,_0x4adaa2,_0xced4ad,_0x430cc2,_0x575715,_0x3cf1ff,_0x40d9cf,_0x40d9cf);},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)]['changeSvActorGraphicBitmap']=function(_0x5a9859){const _0x591d58=_0x46d610,_0x5a5213=this[_0x591d58(0x2e7)](),_0x2f7d3c=this[_0x591d58(0x2c5)](),_0x383347=Math[_0x591d58(0x33e)](_0x5a5213,_0x2f7d3c);this[_0x591d58(0x2b9)][_0x591d58(0x14a)]=new Bitmap(_0x5a5213,_0x2f7d3c);const _0x1f6677=this['_graphicSprite']['bitmap'],_0x8ca0cb=0x9,_0x1361bc=0x6,_0x1fbe2f=_0x5a9859[_0x591d58(0x205)]/_0x8ca0cb,_0xdd29c5=_0x5a9859[_0x591d58(0x2b7)]/_0x1361bc,_0x206312=Math[_0x591d58(0x33e)](0x1,_0x383347/_0x1fbe2f,_0x383347/_0xdd29c5),_0x5e8dc1=_0x1fbe2f*_0x206312,_0xf40024=_0xdd29c5*_0x206312,_0x3e02f4=Math['round']((_0x5a5213-_0x5e8dc1)/0x2),_0x2fb751=Math[_0x591d58(0x267)]((_0x2f7d3c-_0xf40024)/0x2);_0x1f6677['blt'](_0x5a9859,0x0,0x0,_0x1fbe2f,_0xdd29c5,_0x3e02f4,_0x2fb751,_0x5e8dc1,_0xf40024);},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x2ac)]=function(_0x28e940){const _0x18f65b=_0x46d610,_0x3fc003=Window_CTB_TurnOrder[_0x18f65b(0x311)],_0x12bec6=this[_0x18f65b(0x2e7)](),_0x4230d3=this['bitmapHeight'](),_0x1d004c=Math['min'](_0x12bec6,_0x4230d3);this['_graphicSprite'][_0x18f65b(0x14a)]=new Bitmap(_0x12bec6,_0x4230d3);const _0x34143a=this['_graphicSprite']['bitmap'],_0x2dece0=Math[_0x18f65b(0x33e)](0x1,_0x1d004c/_0x28e940[_0x18f65b(0x205)],_0x1d004c/_0x28e940[_0x18f65b(0x2b7)]),_0xd4300c=_0x28e940[_0x18f65b(0x205)]*_0x2dece0,_0x4dea2c=_0x28e940[_0x18f65b(0x2b7)]*_0x2dece0,_0x15ee2a=Math[_0x18f65b(0x267)]((_0x12bec6-_0xd4300c)/0x2),_0x69d5d5=Math[_0x18f65b(0x267)]((_0x4230d3-_0x4dea2c)/0x2);_0x34143a[_0x18f65b(0x28a)](_0x28e940,0x0,0x0,_0x28e940[_0x18f65b(0x205)],_0x28e940[_0x18f65b(0x2b7)],_0x15ee2a,_0x69d5d5,_0xd4300c,_0x4dea2c);},Sprite_CTB_TurnOrder_Battler['prototype'][_0x46d610(0x15a)]=function(){const _0x284ac9=_0x46d610,_0x284b2b=this[_0x284ac9(0x299)]();if(!_0x284b2b)return;if(!_0x284b2b[_0x284ac9(0x1f0)]())return;if(this['_graphicHue']===_0x284b2b[_0x284ac9(0x2c3)]())return;this[_0x284ac9(0x2e1)]=_0x284b2b[_0x284ac9(0x2c3)]();if(_0x284b2b['hasSvBattler']())this[_0x284ac9(0x2e1)]=0x0;this[_0x284ac9(0x2b9)][_0x284ac9(0x29d)](this[_0x284ac9(0x2e1)]);},Sprite_CTB_TurnOrder_Battler['prototype'][_0x46d610(0x298)]=function(){const _0x53926e=_0x46d610;if(!this['_letterSprite'])return;const _0x3b96a3=this[_0x53926e(0x299)]();if(!_0x3b96a3)return;if(this[_0x53926e(0x2e0)]===_0x3b96a3[_0x53926e(0x2e0)]&&this[_0x53926e(0x188)]===_0x3b96a3[_0x53926e(0x188)])return;this['_letter']=_0x3b96a3['_letter'],this['_plural']=_0x3b96a3[_0x53926e(0x188)];const _0x39affa=Window_CTB_TurnOrder['Settings'],_0x225592=this[_0x53926e(0x1cd)](),_0x337c25=this[_0x53926e(0x2e7)](),_0x4a7174=this[_0x53926e(0x2c5)](),_0x4c564a=this['_letterSprite'][_0x53926e(0x14a)];_0x4c564a[_0x53926e(0x1e8)]();if(!this[_0x53926e(0x188)])return;_0x4c564a[_0x53926e(0x2ed)]=_0x39affa[_0x53926e(0x263)]||$gameSystem[_0x53926e(0x266)](),_0x4c564a[_0x53926e(0x325)]=_0x39affa[_0x53926e(0x1b9)]||0x10;if(_0x225592){if(_0x53926e(0x179)==='uKAJx')_0x4c564a[_0x53926e(0x2b3)](this['_letter'][_0x53926e(0x2ce)](),0x0,_0x4a7174/0x2,_0x337c25,_0x4a7174/0x2,_0x53926e(0x21f));else{if(!this[_0x53926e(0x268)])return;const _0xd9dc5b=this['battler']();if(!_0xd9dc5b)return;if(this[_0x53926e(0x2e0)]===_0xd9dc5b['_letter']&&this[_0x53926e(0x188)]===_0xd9dc5b['_plural'])return;this['_letter']=_0xd9dc5b[_0x53926e(0x2e0)],this['_plural']=_0xd9dc5b[_0x53926e(0x188)];const _0x236771=_0x39b945[_0x53926e(0x311)],_0x496a40=this[_0x53926e(0x1cd)](),_0x3650bd=this[_0x53926e(0x2e7)](),_0x26af13=this[_0x53926e(0x2c5)](),_0x207791=this[_0x53926e(0x268)][_0x53926e(0x14a)];_0x207791[_0x53926e(0x1e8)]();if(!this[_0x53926e(0x188)])return;_0x207791['fontFace']=_0x236771['EnemyBattlerFontFace']||_0x87bbdd['mainFontFace'](),_0x207791[_0x53926e(0x325)]=_0x236771['EnemyBattlerFontSize']||0x10,_0x496a40?_0x207791[_0x53926e(0x2b3)](this[_0x53926e(0x2e0)][_0x53926e(0x2ce)](),0x0,_0x26af13/0x2,_0x3650bd,_0x26af13/0x2,_0x53926e(0x21f)):_0x207791['drawText'](this[_0x53926e(0x2e0)][_0x53926e(0x2ce)](),0x0,0x2,_0x3650bd-0x8,_0x26af13-0x4,_0x53926e(0x335));}}else{if(_0x53926e(0x312)!==_0x53926e(0x312)){const _0x5320c6=this[_0x53926e(0x1c7)],_0x8fb3a5=this[_0x53926e(0x2e7)](),_0x3eb135=this[_0x53926e(0x2c5)]();this[_0x53926e(0x2b9)]['bitmap']=new _0x5ebde8(_0x8fb3a5,_0x3eb135);const _0x4295c5=this['_graphicSprite'][_0x53926e(0x14a)],_0x8e3fae=_0x51e97c[_0x53926e(0x257)],_0x35baf6=_0x27109c[_0x53926e(0x2d7)],_0x4cce02=_0x224b97['min'](_0x8e3fae,_0x35baf6,_0x8fb3a5,_0x3eb135),_0x592eaf=_0x5320c6%0x10*_0x8e3fae,_0x2f70ce=_0x78a542[_0x53926e(0x189)](_0x5320c6/0x10)*_0x35baf6,_0x728720=_0x39f670[_0x53926e(0x189)](_0x3a03f3[_0x53926e(0x14c)](_0x8fb3a5-_0x4cce02,0x0)/0x2),_0x27ff0b=_0x4958ba[_0x53926e(0x189)](_0x26502c[_0x53926e(0x14c)](_0x3eb135-_0x4cce02,0x0)/0x2);_0x4295c5[_0x53926e(0x28a)](_0x979192,_0x592eaf,_0x2f70ce,_0x8e3fae,_0x35baf6,_0x728720,_0x27ff0b,_0x4cce02,_0x4cce02);}else _0x4c564a[_0x53926e(0x2b3)](this[_0x53926e(0x2e0)][_0x53926e(0x2ce)](),0x0,0x2,_0x337c25-0x8,_0x4a7174-0x4,'right');}},Sprite_CTB_TurnOrder_Battler[_0x46d610(0x341)][_0x46d610(0x17d)]=function(){const _0x35a4b0=_0x46d610,_0x1c8980=this[_0x35a4b0(0x299)]();if(!_0x1c8980)return;const _0x4de532=_0x1c8980[_0x35a4b0(0x299)]();if(!_0x4de532)return;const _0x5dcaf0=_0x4de532['mainSprite']();if(!_0x5dcaf0)return;this[_0x35a4b0(0x277)](_0x5dcaf0[_0x35a4b0(0x17a)]);},Sprite_CTB_TurnOrder_Battler['prototype'][_0x46d610(0x2fa)]=function(){const _0x17e8ee=_0x46d610;return this[_0x17e8ee(0x299)]();},VisuMZ[_0x46d610(0x1be)]['Window_Help_setItem']=Window_Help[_0x46d610(0x341)][_0x46d610(0x18b)],Window_Help[_0x46d610(0x341)][_0x46d610(0x18b)]=function(_0x5a757d){const _0x1e183a=_0x46d610;if(BattleManager['isCTB']()&&_0x5a757d&&_0x5a757d[_0x1e183a(0x31c)]&&_0x5a757d[_0x1e183a(0x31c)][_0x1e183a(0x13b)](/<(?:CTB) HELP>\s*([\s\S]*)\s*<\/(?:CTB) HELP>/i))this[_0x1e183a(0x25d)](String(RegExp['$1']));else{if('ypFDS'===_0x1e183a(0x1c2))VisuMZ[_0x1e183a(0x1be)][_0x1e183a(0x167)][_0x1e183a(0x17f)](this,_0x5a757d);else{const _0xa9f2de=this[_0x1e183a(0x183)];this['x']=(this['x']*(_0xa9f2de-0x1)+this['_positionTargetX'])/_0xa9f2de,this['y']=(this['y']*(_0xa9f2de-0x1)+this[_0x1e183a(0x199)])/_0xa9f2de,this[_0x1e183a(0x183)]--;}}},VisuMZ[_0x46d610(0x1be)]['Window_StatusBase_placeGauge']=Window_StatusBase[_0x46d610(0x341)][_0x46d610(0x314)],Window_StatusBase[_0x46d610(0x341)][_0x46d610(0x314)]=function(_0x5ca2c8,_0x2751fc,_0x20ed16,_0x5eedea){const _0x6544e0=_0x46d610;if(BattleManager[_0x6544e0(0x1d1)]()&&_0x2751fc===_0x6544e0(0x1b6))return;VisuMZ[_0x6544e0(0x1be)][_0x6544e0(0x1f2)][_0x6544e0(0x17f)](this,_0x5ca2c8,_0x2751fc,_0x20ed16,_0x5eedea);};function Window_CTB_TurnOrder(){const _0x46f225=_0x46d610;this[_0x46f225(0x186)](...arguments);}Window_CTB_TurnOrder[_0x46d610(0x341)]=Object['create'](Window_Base['prototype']),Window_CTB_TurnOrder['prototype'][_0x46d610(0x253)]=Window_CTB_TurnOrder,Window_CTB_TurnOrder[_0x46d610(0x311)]=VisuMZ[_0x46d610(0x1be)]['Settings'][_0x46d610(0x256)],Window_CTB_TurnOrder['prototype'][_0x46d610(0x186)]=function(){const _0x2c5907=_0x46d610,_0x5d6403=this['windowRect']();this[_0x2c5907(0x306)]=_0x5d6403['x'],this[_0x2c5907(0x22e)]=_0x5d6403['y'],Window_Base['prototype'][_0x2c5907(0x186)]['call'](this,_0x5d6403),this[_0x2c5907(0x229)](),this[_0x2c5907(0x2c4)](),this[_0x2c5907(0x294)]=0x0;},Window_CTB_TurnOrder['prototype'][_0x46d610(0x246)]=function(){const _0x503c16=_0x46d610,_0x4c96da=Window_CTB_TurnOrder['Settings'],_0x1a0d9b=SceneManager[_0x503c16(0x2fc)]['_statusWindow'][_0x503c16(0x2b7)],_0x227f4a=SceneManager['_scene'][_0x503c16(0x2e3)]['height'],_0x503f8a=_0x4c96da['SubjectDistance'];let _0x86704a=0x0,_0x4806d9=0x0,_0x306836=0x0,_0x5efa7d=0x0;switch(_0x4c96da['DisplayPosition']){case _0x503c16(0x1c9):_0x86704a=_0x4c96da[_0x503c16(0x2b6)]*_0x4c96da['TotalHorzSprites']+_0x503f8a,_0x4806d9=_0x4c96da[_0x503c16(0x1d7)],_0x306836=Math[_0x503c16(0x211)]((Graphics[_0x503c16(0x205)]-_0x86704a)/0x2),_0x5efa7d=_0x4c96da[_0x503c16(0x24b)];break;case _0x503c16(0x19e):_0x86704a=_0x4c96da[_0x503c16(0x2b6)]*_0x4c96da[_0x503c16(0x333)]+_0x503f8a,_0x4806d9=_0x4c96da[_0x503c16(0x1d7)],_0x306836=Math[_0x503c16(0x211)]((Graphics[_0x503c16(0x205)]-_0x86704a)/0x2),_0x5efa7d=Graphics['height']-_0x1a0d9b-_0x4806d9-_0x4c96da[_0x503c16(0x24b)];break;case _0x503c16(0x2ef):_0x86704a=_0x4c96da[_0x503c16(0x1d7)],_0x4806d9=_0x4c96da['SpriteThin']*_0x4c96da['TotalVertSprites']+_0x503f8a,_0x306836=_0x4c96da[_0x503c16(0x24b)],_0x5efa7d=Math[_0x503c16(0x211)]((Graphics[_0x503c16(0x2b7)]-_0x1a0d9b+_0x227f4a-_0x4806d9)/0x2);break;case _0x503c16(0x335):_0x86704a=_0x4c96da[_0x503c16(0x1d7)],_0x4806d9=_0x4c96da['SpriteThin']*_0x4c96da[_0x503c16(0x2a3)]+_0x503f8a,_0x306836=Graphics[_0x503c16(0x205)]-_0x86704a-_0x4c96da[_0x503c16(0x24b)],_0x5efa7d=Math[_0x503c16(0x211)]((Graphics[_0x503c16(0x2b7)]-_0x1a0d9b+_0x227f4a-_0x4806d9)/0x2);break;}return _0x306836+=_0x4c96da[_0x503c16(0x303)],_0x5efa7d+=_0x4c96da[_0x503c16(0x21d)],new Rectangle(_0x306836,_0x5efa7d,_0x86704a,_0x4806d9);},Window_CTB_TurnOrder['prototype'][_0x46d610(0x161)]=function(){const _0x179898=_0x46d610;this[_0x179898(0x29c)]=0x0;},Window_CTB_TurnOrder[_0x46d610(0x341)][_0x46d610(0x1cd)]=function(){const _0xb96415=_0x46d610,_0xc329cb=Window_CTB_TurnOrder[_0xb96415(0x311)],_0x506685=[_0xb96415(0x1c9),_0xb96415(0x19e)][_0xb96415(0x2d3)](_0xc329cb['DisplayPosition']);return _0x506685;},Window_CTB_TurnOrder[_0x46d610(0x341)][_0x46d610(0x229)]=function(){const _0x34dcd6=_0x46d610,_0x42cb4f=Window_CTB_TurnOrder['Settings'],_0x46ea5e=this['isHorz'](),_0x4675ef=_0x46ea5e?_0x42cb4f[_0x34dcd6(0x333)]:_0x42cb4f[_0x34dcd6(0x2a3)];this['_turnOrderInnerSprite']=new Sprite(),this[_0x34dcd6(0x2d4)](this[_0x34dcd6(0x22f)]),this[_0x34dcd6(0x235)]=[];for(let _0x51fb62=0x0;_0x51fb62<$gameParty['maxBattleMembers']();_0x51fb62++){if(_0x34dcd6(0x21a)===_0x34dcd6(0x1a0)){if(_0x526713[_0x34dcd6(0x1d1)]()){let _0x33929d=_0x5eb33a[_0x34dcd6(0x1be)][_0x34dcd6(0x311)][_0x34dcd6(0x324)][_0x34dcd6(0x1e2)][_0x34dcd6(0x17f)](this,this);const _0x405ffe=0x0;return _0x33929d+_0x405ffe;}else return _0x2088b8[_0x34dcd6(0x1be)][_0x34dcd6(0x21c)]['call'](this);}else for(let _0x4464cc=0x0;_0x4464cc<_0x4675ef;_0x4464cc++){const _0x364271=new Sprite_CTB_TurnOrder_Battler($gameParty,_0x51fb62,_0x4464cc);this[_0x34dcd6(0x22f)][_0x34dcd6(0x1bb)](_0x364271),this['_turnOrderContainer'][_0x34dcd6(0x18f)](_0x364271);}}for(let _0x413604=0x0;_0x413604<0x8;_0x413604++){for(let _0x1e902d=0x0;_0x1e902d<_0x4675ef;_0x1e902d++){const _0x5d64a0=new Sprite_CTB_TurnOrder_Battler($gameTroop,_0x413604,_0x1e902d);this[_0x34dcd6(0x22f)][_0x34dcd6(0x1bb)](_0x5d64a0),this[_0x34dcd6(0x235)]['push'](_0x5d64a0);}}},Window_CTB_TurnOrder[_0x46d610(0x341)][_0x46d610(0x2ec)]=function(){const _0x5d59b5=_0x46d610;Window_Base['prototype'][_0x5d59b5(0x2ec)][_0x5d59b5(0x17f)](this),this[_0x5d59b5(0x272)](),this[_0x5d59b5(0x244)](),this[_0x5d59b5(0x2c4)]();},Window_CTB_TurnOrder[_0x46d610(0x341)]['updatePosition']=function(){const _0xc83f73=_0x46d610,_0xc3e27c=Window_CTB_TurnOrder[_0xc83f73(0x311)];if(_0xc3e27c[_0xc83f73(0x33b)]!=='top')return;if(!_0xc3e27c[_0xc83f73(0x1fc)])return;const _0x45ef81=SceneManager[_0xc83f73(0x2fc)]['_helpWindow'];if(!_0x45ef81)return;_0x45ef81[_0xc83f73(0x2b1)]?(this['x']=this[_0xc83f73(0x306)]+(_0xc3e27c[_0xc83f73(0x1ac)]||0x0),this['y']=this[_0xc83f73(0x22e)]+(_0xc3e27c['RepositionTopHelpY']||0x0)):(this['x']=this[_0xc83f73(0x306)],this['y']=this[_0xc83f73(0x22e)]);const _0x12c3f4=SceneManager['_scene'][_0xc83f73(0x280)];this[_0xc83f73(0x171)]===undefined&&(this[_0xc83f73(0x171)]=Math[_0xc83f73(0x267)]((Graphics['width']-Math[_0xc83f73(0x33e)](Graphics[_0xc83f73(0x300)],_0x12c3f4['width']))/0x2),this['_ogWindowLayerY']=Math[_0xc83f73(0x267)]((Graphics[_0xc83f73(0x2b7)]-Math[_0xc83f73(0x33e)](Graphics['boxHeight'],_0x12c3f4[_0xc83f73(0x2b7)]))/0x2)),this['x']+=_0x12c3f4['x']-this[_0xc83f73(0x171)],this['y']+=_0x12c3f4['y']-this['_ogWindowLayerY'];},Window_CTB_TurnOrder[_0x46d610(0x341)][_0x46d610(0x244)]=function(){const _0x1c2a5c=_0x46d610;if(!this['_turnOrderInnerSprite'])return;const _0x53a625=this[_0x1c2a5c(0x22f)][_0x1c2a5c(0x2a2)];if(!_0x53a625)return;_0x53a625[_0x1c2a5c(0x32a)](this[_0x1c2a5c(0x14e)]['bind'](this));},Window_CTB_TurnOrder[_0x46d610(0x341)][_0x46d610(0x14e)]=function(_0x534a3b,_0x55ed07){const _0x3c15cb=_0x46d610,_0x3883f8=this[_0x3c15cb(0x1cd)](),_0x4e8c71=Window_CTB_TurnOrder[_0x3c15cb(0x311)]['OrderDirection'];if(_0x3883f8&&!_0x4e8c71){if('KUvxq'===_0x3c15cb(0x19b)){let _0x277462='';if(_0x292e96[_0x3c15cb(0x2d3)](_0x1054a6))_0x277462=_0x3c15cb(0x170)[_0x3c15cb(0x1cc)](_0x1a05b0['id'],_0x24fd07);if(_0x5c8fe2[_0x3c15cb(0x2d3)](_0x2c430a))_0x277462='Class-%1-%2'['format'](_0x4af002['id'],_0x262af0);if(_0x459d44[_0x3c15cb(0x2d3)](_0x2b271d))_0x277462='Skill-%1-%2'[_0x3c15cb(0x1cc)](_0x1b891d['id'],_0x233f7b);if(_0x4c3d1f[_0x3c15cb(0x2d3)](_0x3224d5))_0x277462='Item-%1-%2'[_0x3c15cb(0x1cc)](_0x52f090['id'],_0x5dd4c1);if(_0x2683a6[_0x3c15cb(0x2d3)](_0x539937))_0x277462=_0x3c15cb(0x218)[_0x3c15cb(0x1cc)](_0x29a034['id'],_0x4dfdb1);if(_0xb351d3[_0x3c15cb(0x2d3)](_0xdbb428))_0x277462=_0x3c15cb(0x178)[_0x3c15cb(0x1cc)](_0x4f3201['id'],_0x2ab79e);if(_0x519ecf[_0x3c15cb(0x2d3)](_0x23bc57))_0x277462='Enemy-%1-%2'['format'](_0x5db6d7['id'],_0x132e50);if(_0x1c2da6[_0x3c15cb(0x2d3)](_0x52a090))_0x277462=_0x3c15cb(0x2cd)[_0x3c15cb(0x1cc)](_0x9bbb96['id'],_0x3bcc1b);return _0x277462;}else return _0x534a3b['x']-_0x55ed07['x'];}else{if(_0x3883f8&&_0x4e8c71){if(_0x3c15cb(0x227)!==_0x3c15cb(0x227)){const _0x444a8c=_0x520ce4['Settings'],_0x10e275=this['isHorz'](),_0x31c642=_0x10e275?_0x444a8c[_0x3c15cb(0x333)]:_0x444a8c[_0x3c15cb(0x2a3)];this[_0x3c15cb(0x2a6)]-=0x1,this['_dupe']<0x0&&(this['_dupe']=_0x31c642-0x1,this['startFade'](0x0));}else return _0x55ed07['x']-_0x534a3b['x'];}else{if(!_0x3883f8&&_0x4e8c71)return _0x3c15cb(0x2bd)===_0x3c15cb(0x2bd)?_0x534a3b['y']-_0x55ed07['y']:_0x38599c[_0x3c15cb(0x311)]['EnemyBattlerType'];else{if(!_0x3883f8&&!_0x4e8c71){if(_0x3c15cb(0x1f7)==='OjIoZ')return _0x55ed07['y']-_0x534a3b['y'];else _0x33b1cc['changeCtbCastTime'](_0x2a8ef8(_0x1ac726['$1'])*0.01);}}}}},Window_CTB_TurnOrder[_0x46d610(0x341)]['updateVisibility']=function(){const _0x16b1ab=_0x46d610;this[_0x16b1ab(0x2b1)]=$gameSystem[_0x16b1ab(0x1c8)]();},Window_CTB_TurnOrder[_0x46d610(0x341)]['updateTurnOrder']=function(_0x18c1c3){const _0x53905e=_0x46d610;this[_0x53905e(0x235)]['sort']((_0x21e95a,_0x177d29)=>{const _0x431470=_0x53905e;return _0x21e95a[_0x431470(0x2c8)]()-_0x177d29[_0x431470(0x2c8)]();});if(!_0x18c1c3)return;for(const _0x32fb70 of this['_turnOrderContainer']){if(_0x53905e(0x1b5)!==_0x53905e(0x1b5)){if(!_0x48d277[_0x53905e(0x311)]['ShowMarkerBorder'])return;const _0x3a7059=_0x2692a7['Settings'],_0x2ade1c=this['_unit']===_0x262b3d?_0x53905e(0x2c9):_0x53905e(0x25b),_0x4b7e58='%1SystemBorder'['format'](_0x2ade1c),_0x53c1cc=new _0x455f62();_0x53c1cc['anchor']['x']=this[_0x53905e(0x2f0)]['x'],_0x53c1cc[_0x53905e(0x2f0)]['y']=this[_0x53905e(0x2f0)]['y'];if(_0x3a7059[_0x4b7e58])_0x53c1cc[_0x53905e(0x14a)]=_0x45c9ea['loadSystem'](_0x3a7059[_0x4b7e58]);else{let _0x483b6a=this[_0x53905e(0x2e7)](),_0x273fb0=this[_0x53905e(0x2c5)](),_0xff8be5=_0x3a7059[_0x53905e(0x19f)];_0x53c1cc[_0x53905e(0x14a)]=new _0x13ca7d(_0x483b6a,_0x273fb0);const _0x4f4351='#000000',_0x2d586d=_0x32d2f2[_0x53905e(0x1ad)](_0x3a7059[_0x53905e(0x326)[_0x53905e(0x1cc)](_0x2ade1c)]);_0x53c1cc['bitmap'][_0x53905e(0x1fd)](0x0,0x0,_0x483b6a,_0x273fb0,_0x4f4351),_0x483b6a-=0x2,_0x273fb0-=0x2,_0x53c1cc[_0x53905e(0x14a)][_0x53905e(0x1fd)](0x1,0x1,_0x483b6a,_0x273fb0,_0x2d586d),_0x483b6a-=_0xff8be5*0x2,_0x273fb0-=_0xff8be5*0x2,_0x53c1cc[_0x53905e(0x14a)]['fillRect'](0x1+_0xff8be5,0x1+_0xff8be5,_0x483b6a,_0x273fb0,_0x4f4351),_0x483b6a-=0x2,_0x273fb0-=0x2,_0xff8be5+=0x1,_0x53c1cc['bitmap'][_0x53905e(0x20e)](0x1+_0xff8be5,0x1+_0xff8be5,_0x483b6a,_0x273fb0);}this[_0x53905e(0x2ee)]=_0x53c1cc,this['addChild'](this['_backgroundSprite']);}else{if(!_0x32fb70)continue;_0x32fb70[_0x53905e(0x2ec)](),_0x32fb70[_0x53905e(0x183)]=0x0;}}},Window_CTB_TurnOrder[_0x46d610(0x341)][_0x46d610(0x139)]=function(_0x360533){const _0x235344=_0x46d610;for(const _0x583eb1 of this['_turnOrderContainer']){if(!_0x583eb1)continue;if(_0x583eb1[_0x235344(0x299)]()!==_0x360533)continue;_0x583eb1[_0x235344(0x148)]();}};